/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.session.encode;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.tinygroup.commons.io.ByteArrayOutputStream;
import org.tinygroup.commons.tools.ArrayUtil;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.convert.objectjson.jackson.JsonToObject;
import org.tinygroup.convert.objectjson.jackson.ObjectToJson;
import org.tinygroup.weblayer.webcontext.session.SessionStore;
import org.tinygroup.weblayer.webcontext.session.encode.SessionEncoder;
import org.tinygroup.weblayer.webcontext.session.exception.SessionEncoderException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonConvertSessionEncoder
implements SessionEncoder {
    @Override
    public String encode(Map<String, Object> attrs, SessionStore.StoreContext storeContext) throws SessionEncoderException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectToJson objectToXml = new ObjectToJson(JsonSerialize.Inclusion.NON_NULL);
        String result = objectToXml.convert(attrs);
        try {
            baos.write(result.getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new SessionEncoderException("Failed to encode session state", e);
        }
        finally {
            baos.close();
        }
        byte[] plaintext = baos.toByteArray().toByteArray();
        try {
            String encodedValue = new String(Base64.encodeBase64((byte[])plaintext, (boolean)false), "ISO-8859-1");
            return URLEncoder.encode(encodedValue, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new SessionEncoderException("Failed to encode session state", e);
        }
    }

    @Override
    public Map<String, Object> decode(String encodedValue, SessionStore.StoreContext storeContext) throws SessionEncoderException {
        byte[] cryptotext = null;
        try {
            encodedValue = URLDecoder.decode((String)Assert.assertNotNull((Object)encodedValue, (String)"encodedValue is null", (Object[])new Object[0]), "ISO-8859-1");
            cryptotext = Base64.decodeBase64((byte[])encodedValue.getBytes("ISO-8859-1"));
            if (ArrayUtil.isEmptyArray((Object)cryptotext)) {
                throw new SessionEncoderException("Session state is empty: " + encodedValue);
            }
        }
        catch (Exception e) {
            throw new SessionEncoderException("Failed to decode session state: ", e);
        }
        if (ArrayUtil.isEmptyArray((Object)cryptotext)) {
            throw new SessionEncoderException("Decrypted session state is empty: " + encodedValue);
        }
        try {
            JsonToObject jsonToObject = new JsonToObject(HashMap.class);
            Map attrs = (Map)jsonToObject.convert(new String(cryptotext, "UTF-8"));
            return attrs;
        }
        catch (Exception e) {
            throw new SessionEncoderException("Failed to parse session state", e);
        }
    }
}

