/**
 *  Copyright (c) 1997-2013, tinygroup.org (luo_guo@live.cn).
 *
 *  Licensed under the GPL, Version 3.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       http://www.gnu.org/licenses/gpl.html
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * --------------------------------------------------------------------------
 *  版权 (c) 1997-2013, tinygroup.org (luo_guo@live.cn).
 *
 *  本开源软件遵循 GPL 3.0 协议;
 *  如果您不遵循此协议，则不被允许使用此文件。
 *  你可以从下面的地址获取完整的协议文本
 *
 *       http://www.gnu.org/licenses/gpl.html
 */
package org.tinygroup.weblayer.listener;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;

import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

import org.tinygroup.commons.tools.Assert;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.commons.tools.Enumerator;
import org.tinygroup.fileresolver.FullContextFileRepository;
import org.tinygroup.springutil.SpringUtil;
import org.tinygroup.vfs.FileObject;

/**
 * tiny框架 ServletContext实现
 * @author renhui
 *
 */
public class TinyServletContext implements ServletContext {
	
    private ServletContext orignalContext;
    
    private FullContextFileRepository fullContextFileRepository;

    private Map<String,String> parameters=CollectionUtil.createHashMap();
    
	public TinyServletContext(ServletContext servletContext){
		Assert.assertNotNull(servletContext, "servletContext must not null");
		this.orignalContext=servletContext;
		fullContextFileRepository=SpringUtil.getBean("fullContextFileRepository");
	}
	
	public String getContextPath() {
		return orignalContext.getContextPath();
	}

	public ServletContext getContext(String uripath) {
		return orignalContext.getContext(uripath);
	}

	public int getMajorVersion() {
		return orignalContext.getMajorVersion();
	}

	public int getMinorVersion() {
		return orignalContext.getMinorVersion();
	}

	public String getMimeType(String file) {
		return orignalContext.getMimeType(file);
	}

	public Set getResourcePaths(String path) {
		return orignalContext.getResourcePaths(path);
	}

	public URL getResource(String path) throws MalformedURLException {
		
		if(fullContextFileRepository!=null){
			FileObject fileObject = fullContextFileRepository
					.getFileObject(path);
			if(fileObject != null && fileObject.isExist()){
				return fileObject.getURL();
			}
		}
		return orignalContext.getResource(path);
	}

	public InputStream getResourceAsStream(String path) {
		if(fullContextFileRepository!=null){
			FileObject fileObject = fullContextFileRepository
					.getFileObject(path);
			if(fileObject != null && fileObject.isExist()){
				return fileObject.getInputStream();
			}
		}
		return orignalContext.getResourceAsStream(path);
	}

	public RequestDispatcher getRequestDispatcher(String path) {
		return orignalContext.getRequestDispatcher(path);
	}

	public RequestDispatcher getNamedDispatcher(String name) {
		return orignalContext.getNamedDispatcher(name);
	}
    @Deprecated
	public Servlet getServlet(String name) throws ServletException {
		return orignalContext.getServlet(name);
	}

	@Deprecated
	public Enumeration getServlets() {
		return orignalContext.getServlets();
	}

	public Enumeration getServletNames() {
		return orignalContext.getServletNames();
	}

	public void log(String msg) {
         orignalContext.log(msg);
	}
    @Deprecated
	public void log(Exception exception, String msg) {
		orignalContext.log(exception, msg);

	}

	public void log(String message, Throwable throwable) {
		orignalContext.log(message, throwable);

	}

	public String getRealPath(String path) {
	    return orignalContext.getRealPath(path);
	}

	public String getServerInfo() {
		return orignalContext.getServerInfo();
	}

	public String getInitParameter(String name) {
		String value= parameters.get(name);
		if(value==null){
			value= orignalContext.getInitParameter(name);
		}
		return value;
	}

	public Enumeration getInitParameterNames() {
		Enumeration enumeration=orignalContext.getInitParameterNames();
		Set<String> parameterSet=parameters.keySet();
		while (enumeration.hasMoreElements()) {
			String name = (String) enumeration.nextElement();
			parameterSet.add(name);
		}
		return new Enumerator(parameterSet);
	}

	public Object getAttribute(String name) {
		return orignalContext.getAttribute(name);
	}

	public Enumeration getAttributeNames() {
		return orignalContext.getAttributeNames();
	}

	public void setAttribute(String name, Object object) {
		orignalContext.setAttribute(name, object);
	}

	public void removeAttribute(String name) {
		orignalContext.removeAttribute(name);
	}

	public String getServletContextName() {
		return orignalContext.getServletContextName();
	}

	public void setInitParameter(String name,String value){
		parameters.put(name, value);
	}
}
