/**
 *  Copyright (c) 1997-2013, tinygroup.org (luo_guo@live.cn).
 *
 *  Licensed under the GPL, Version 3.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       http://www.gnu.org/licenses/gpl.html
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * --------------------------------------------------------------------------
 *  版权 (c) 1997-2013, tinygroup.org (luo_guo@live.cn).
 *
 *  本开源软件遵循 GPL 3.0 协议;
 *  如果您不遵循此协议，则不被允许使用此文件。
 *  你可以从下面的地址获取完整的协议文本
 *
 *       http://www.gnu.org/licenses/gpl.html
 */
package org.tinygroup.weblayer.servlet;

import java.io.IOException;
import java.util.UUID;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.tinygroup.cepcore.EventProcessor;
import org.tinygroup.datasource.DatasourceInfo;
import org.tinygroup.event.Event;
import org.tinygroup.event.ServiceRequest;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.plugin.PluginManager;
import org.tinygroup.weblayer.WebContext;
import org.tinygroup.weblayer.impl.WebContextImpl;

public class FlowServlet extends HttpServlet {
	private static final String ERROR_NO_NOERROR = "0";
	private static final String ERROR_NO = "1";
	private static final String OUT_PUT_KEY = "$_out_put_key";
	private static final String IS_OUT_PUT = "$_isOutPut";
	Logger logger = LoggerFactory.getLogger(FlowServlet.class);

	public void init() {

	}
	PluginManager pluginManager;

	public void setPluginManager(PluginManager pluginManager) {
		this.pluginManager = pluginManager;
	}
	protected void service(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		EventProcessor channel = (EventProcessor) pluginManager.getService(
				pluginManager.getPluginInfo("simplechannel"), "simplechannel");
		WebContext context = new WebContextImpl();
		context.setRequest(request);
		context.setResponse(response);
		String serviceId = getRequestId(request);
		Event event = new Event();
		event.setEventId(UUID.randomUUID().toString());
		// context.put("serviceId", "serviceSayHello");
		// context.put("serviceName", "serviceSayHello");
		ServiceRequest serviceRequest = new ServiceRequest();
		serviceRequest.setContext(context);
		serviceRequest.setServiceId(serviceId);
		serviceRequest.setName(serviceId);
		event.setServiceRequest(serviceRequest);
		//TODO 需要实现WebContextProcessor处理
		// datasource处理
		String dataSource = request.getParameter("dataSource");
		DatasourceInfo.putDataSource(dataSource);
		String json = "";
		String error = ERROR_NO_NOERROR;
		String errorInfo = "";
		String data = "";
		//TODO:后面的实现有问题
		try {
			channel.process(event);
			if ((context.get(IS_OUT_PUT) == Boolean.TRUE)
					&& (context.get(OUT_PUT_KEY) != null)) {
				data = context.get(OUT_PUT_KEY).toString();
			}
		} catch (Exception e) {
			error = ERROR_NO;
			errorInfo = e.getMessage();
			logger.errorMessage("流程执行出错", e);
		} finally {
			String errorString = "\"error\":" + error;
			String errorInfoString = "\"errorInfo\":\"" + errorInfo + "\"";
			String dataString = "";
			if ("".equals(data)) {
				dataString = "\"data\":\"\"";
			} else {
				dataString = "\"data\":" + data;
			}

			String responseString = "";
			if (ERROR_NO_NOERROR.equals(error)) {
				responseString = data;
			} else {
				responseString = String.format("{%s,%s}", errorString,
						errorInfoString);
				// String.format("{%s,%s,%s}",
				// errorString,errorInfoString,dataString);
			}
			response.getWriter().write(responseString);
		}

	}

	public String getRequestId(HttpServletRequest request) {
		String requestPath = request.getRequestURI();
		int j = requestPath.lastIndexOf(".");
		int lastL = requestPath.lastIndexOf("/");
		return requestPath.substring(lastL + 1, j);
	}

}
