/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.filter;

import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.tinygroup.appconfig.AppConfigManager;
import org.tinygroup.commons.i18n.LocaleUtil;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.filter.NameFilter;
import org.tinygroup.springutil.SpringUtil;
import org.tinygroup.weblayer.AbstractTinyFilter;
import org.tinygroup.weblayer.WebContext;
import org.tinygroup.weblayer.webcontext.setlocacle.impl.SetLocaleOverrider;
import org.tinygroup.weblayer.webcontext.setlocacle.impl.SetLocaleWebContextImpl;
import org.tinygroup.xmlparser.node.XmlNode;

public class SetLocaleTinyFilter
extends AbstractTinyFilter {
    private static final String DEFAULT_LOCALE = "defaultLocale";
    private static final String DEFAULT_CHARSET = "defaultCharset";
    private static final String INPUT_CHARSET_PARAM = "inputCharsetParam";
    private static final String OUTPUT_CHARSET_PARAM = "outputCharsetParam";
    private static final String PARAM_KEY = "paramKey";
    private static final String SESSION_KEY = "sessionKey";
    private static final String REQUEST_URI_KEY = "url-pattern";
    private static final String INPUT_CHARSET = "input-charset";
    private static final String OUTPUT_CHARSET = "output-charset";
    private static final String SET_LOCALE_CONFIG = "set-locale";
    private static final String OVERRIDER = "overrider";
    private Pattern inputCharsetPattern;
    private Pattern outputCharsetPattern;
    private SetLocaleOverrider[] overriders;
    private Locale defaultLocale;
    private String defaultCharset;
    private String sessionKey;
    private String paramKey;

    private void initFilter() {
        logger.logMessage(LogLevel.INFO, "tiny-filter:<{}>\u521d\u59cb\u5316\u5f00\u59cb", new Object[]{this.getClass().getSimpleName()});
        if (this.defaultLocale == null) {
            this.setDefaultLocale(LocaleUtil.parseLocale((String)StringUtil.defaultIfEmpty((String)this.get(DEFAULT_LOCALE), (String)"en_US")));
        }
        if (this.defaultCharset == null) {
            this.setDefaultCharset(StringUtil.defaultIfEmpty((String)this.get(DEFAULT_CHARSET), (String)"UTF-8"));
        }
        if (this.inputCharsetPattern == null) {
            String inputCharsetParam = StringUtil.defaultIfEmpty((String)this.get(INPUT_CHARSET_PARAM), (String)"_input_charset");
            this.setInputCharsetPattern(Pattern.compile("(" + inputCharsetParam + ")=([\\w-]+)"));
        }
        if (this.outputCharsetPattern == null) {
            String outputCharsetParam = StringUtil.defaultIfEmpty((String)this.get(OUTPUT_CHARSET_PARAM), (String)"_output_charset");
            this.setOutputCharsetPattern(Pattern.compile("(" + outputCharsetParam + ")=([\\w-]+)"));
        }
        if (this.paramKey == null) {
            this.setParamKey(StringUtil.defaultIfEmpty((String)this.get(PARAM_KEY), (String)"_lang"));
        }
        if (this.sessionKey == null) {
            this.setSessionKey(StringUtil.defaultIfEmpty((String)this.get(SESSION_KEY), (String)"_lang"));
        }
        if (this.overriders == null) {
            AppConfigManager appConfigManager = (AppConfigManager)SpringUtil.getBean((String)"appConfigManager");
            XmlNode setLocale = (XmlNode)appConfigManager.getConfiguration().getSubNode(SET_LOCALE_CONFIG);
            this.parserExtraConfig(setLocale);
        }
        logger.logMessage(LogLevel.INFO, "tiny-filter:<{}>\u521d\u59cb\u5316\u7ed3\u675f", new Object[]{this.getClass().getSimpleName()});
    }

    protected void parserExtraConfig(XmlNode setLocale) {
        if (setLocale != null) {
            NameFilter nameFilter = new NameFilter((Node)setLocale);
            List overriderConfigs = nameFilter.findNodeList(OVERRIDER);
            this.overriders = new SetLocaleOverrider[overriderConfigs.size()];
            for (int i = 0; i < overriderConfigs.size(); ++i) {
                XmlNode node = (XmlNode)overriderConfigs.get(i);
                this.overriders[i] = new SetLocaleOverrider(node.getAttribute(REQUEST_URI_KEY), node.getAttribute(INPUT_CHARSET), node.getAttribute(OUTPUT_CHARSET));
            }
        }
    }

    public void setInputCharsetPattern(Pattern inputCharsetPattern) {
        this.inputCharsetPattern = inputCharsetPattern;
    }

    public void setOutputCharsetPattern(Pattern outputCharsetPattern) {
        this.outputCharsetPattern = outputCharsetPattern;
    }

    public void setOverriders(SetLocaleOverrider[] overriders) {
        this.overriders = overriders;
    }

    public void setDefaultLocale(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    public void setDefaultCharset(String defaultCharset) {
        this.defaultCharset = defaultCharset;
    }

    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }

    public void setParamKey(String paramKey) {
        this.paramKey = paramKey;
    }

    public void initTinyFilter() {
        super.initTinyFilter();
        this.initFilter();
    }

    public void preProcess(WebContext context) {
        SetLocaleWebContextImpl setLocale = (SetLocaleWebContextImpl)context;
        setLocale.prepare();
    }

    public void postProcess(WebContext context) {
    }

    protected WebContext getAlreadyWrappedContext(WebContext wrappedContext) {
        SetLocaleWebContextImpl setLocale = new SetLocaleWebContextImpl(wrappedContext);
        setLocale.setDefaultCharset(this.defaultCharset);
        setLocale.setDefaultLocale(this.defaultLocale);
        setLocale.setInputCharsetPattern(this.inputCharsetPattern);
        setLocale.setOutputCharsetPattern(this.outputCharsetPattern);
        setLocale.setOverriders(this.overriders);
        setLocale.setParamKey(this.paramKey);
        setLocale.setSessionKey(this.sessionKey);
        return setLocale;
    }
}

