/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.impl;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.springutil.SpringUtil;
import org.tinygroup.weblayer.AbstractTinyFilter;
import org.tinygroup.weblayer.FilterWrapper;
import org.tinygroup.weblayer.TinyFilterHandler;
import org.tinygroup.weblayer.WebContext;
import org.tinygroup.weblayer.impl.TinyFilterChain;
import org.tinygroup.weblayer.impl.TinyFilterConfig;

public class TinyFilterWrapper
extends AbstractTinyFilter
implements FilterWrapper {
    private static final String SPLIT_CHAR = ",";
    private List<Filter> filters = new ArrayList<Filter>();
    private static final Logger logger = LoggerFactory.getLogger(TinyFilterWrapper.class);

    public void initTinyFilter() {
        super.initTinyFilter();
        String filterBeanNames = this.getInitParamMap().get("filter_beans");
        if (filterBeanNames != null) {
            String[] beanNames = filterBeanNames.split(SPLIT_CHAR);
            logger.logMessage(LogLevel.INFO, "filter\u5305\u88c5\u7c7b\u5f00\u59cb\u5b9e\u4f8b\u5316filter");
            for (String beanName : beanNames) {
                Filter filter = (Filter)SpringUtil.getBean((String)beanName);
                if (filter == null) continue;
                logger.logMessage(LogLevel.INFO, "\u5b9e\u4f8b\u5316filter\uff1a<{}>", new Object[]{beanName});
                try {
                    filter.init((FilterConfig)new TinyFilterConfig(this.getInitParamMap()));
                }
                catch (ServletException e) {
                    logger.errorMessage("\u521d\u59cb\u5316filter:{}\u51fa\u9519", (Throwable)e, new Object[]{beanName});
                    throw new RuntimeException("\u521d\u59cb\u5316filter\u51fa\u9519", e);
                }
                this.filters.add(filter);
            }
        } else {
            throw new RuntimeException("\u627e\u4e0d\u5230bean\u540d\u79f0\uff1a" + filterBeanNames + "\u5bf9\u5e94\u7684filter\u5b9e\u4f8b");
        }
        logger.logMessage(LogLevel.INFO, "filter\u5305\u88c5\u7c7b\u5b9e\u4f8b\u5316filter\u7ed3\u675f");
    }

    public void destoryTinyFilter() {
        super.destoryTinyFilter();
        for (Filter filter : this.filters) {
            filter.destroy();
        }
    }

    public void filterWrapper(WebContext context, TinyFilterHandler hander) {
        HttpServletRequest request = context.getRequest();
        HttpServletResponse response = context.getResponse();
        String servletPath = hander.getServletPath();
        if (this.isMatch(servletPath)) {
            TinyFilterChain filterChain = new TinyFilterChain(this.filters, hander);
            try {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            catch (Exception e) {
                logger.errorMessage("\u8fc7\u6ee4\u5668:{}\u6267\u884c\u51fa\u9519", (Throwable)e, new Object[]{filterChain.currentExcuteFilterName()});
                throw new RuntimeException("\u8fc7\u6ee4\u5668\u6267\u884c\u51fa\u9519", e);
            }
        }
    }
}

