/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.applicationprocessor.configmanager.TinyProcessorConfigManager;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.filter.NameFilter;
import org.tinygroup.springutil.SpringUtil;
import org.tinygroup.weblayer.TinyProcessor;
import org.tinygroup.weblayer.TinyProcessorManager;
import org.tinygroup.weblayer.WebContext;
import org.tinygroup.xmlparser.node.XmlNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TinyProcessorManagerImpl
implements TinyProcessorManager {
    private List<TinyProcessor> tinyProcessorList = new ArrayList<TinyProcessor>();
    private TinyProcessorConfigManager configManager;
    private Map<TinyProcessor, List<XmlNode>> processorXmlNodes = new HashMap<TinyProcessor, List<XmlNode>>();
    private static Logger logger = LoggerFactory.getLogger(TinyProcessorManagerImpl.class);

    @Override
    public boolean execute(String url, WebContext context) {
        boolean canExecute = false;
        for (TinyProcessor tinyProcessor : this.tinyProcessorList) {
            if (!tinyProcessor.isMatch(url)) continue;
            canExecute = true;
            tinyProcessor.process(url, context);
        }
        return canExecute;
    }

    private void nodeProcessor(XmlNode xmlNode) {
        this.processXmlNode(xmlNode);
    }

    private void processXmlNode(XmlNode xmlNode) {
        NameFilter nameFilter = new NameFilter((Node)xmlNode);
        List nodes = nameFilter.findNodeList("tiny-processor");
        for (XmlNode node : nodes) {
            String processorId = node.getAttribute("id");
            String processorClassName = node.getAttribute("class");
            logger.logMessage(LogLevel.INFO, "tiny-processor:{}\u5f00\u59cb\u88ab\u52a0\u8f7d", new Object[]{processorId});
            TinyProcessor processor = null;
            try {
                processor = this.instanceProcessor(processorClassName);
                List<Object> processorNodes = null;
                processorNodes = !this.processorXmlNodes.containsKey(processor) ? new ArrayList() : this.processorXmlNodes.get(processor);
                if (processorNodes != null) {
                    processorNodes.add(node);
                    this.processorXmlNodes.put(processor, processorNodes);
                }
            }
            catch (Exception e) {
                logger.errorMessage("\u521b\u5efatiny-processor\u5904\u7406\u5668\uff1a{}\u51fa\u9519\uff0c\u7531\u4e8e\u5176\u7c7b\u540d\u79f0\uff1a{}\u4e0d\u80fd\u8fdb\u884c\u5b9e\u4f8b\u5316", (Throwable)e, new Object[]{processorId, processorClassName});
                throw new RuntimeException(e);
            }
            logger.logMessage(LogLevel.INFO, "tiny-processor:{}\u52a0\u8f7d\u7ed3\u675f", new Object[]{processorId});
        }
    }

    private void initProcessor() {
        for (TinyProcessor tinyProcessor : this.processorXmlNodes.keySet()) {
            XmlNode xmlNode = this.createXmlNode(this.processorXmlNodes.get(tinyProcessor));
            tinyProcessor.setConfiguration(xmlNode);
            tinyProcessor.init();
            this.tinyProcessorList.add(tinyProcessor);
        }
    }

    private XmlNode createXmlNode(List<XmlNode> xmlNodes) {
        XmlNode newXmlNode = new XmlNode("tiny-processor");
        for (XmlNode xmlNode : xmlNodes) {
            List subNodes = xmlNode.getSubNodes();
            for (XmlNode node : subNodes) {
                newXmlNode.addNode((Node)node);
            }
        }
        return newXmlNode;
    }

    private TinyProcessor instanceProcessor(String servletClassName) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        TinyProcessor processor = (TinyProcessor)SpringUtil.getBean((String)servletClassName);
        if (processor == null) {
            processor = (TinyProcessor)Class.forName(servletClassName).newInstance();
        }
        return processor;
    }

    @Override
    public void initTinyResources() {
        if (this.configManager != null) {
            List configs = this.configManager.getConfigs();
            XmlNode application = this.configManager.getApplicationConfig();
            if (application != null) {
                configs.add(application);
            }
            for (XmlNode config : configs) {
                this.nodeProcessor(config);
            }
            this.initProcessor();
        }
    }

    @Override
    public void setConfigManager(TinyProcessorConfigManager configManager) {
        this.configManager = configManager;
    }

    @Override
    public void destoryTinyResources() {
        for (TinyProcessor tinyProcessor : this.tinyProcessorList) {
            tinyProcessor.destory();
        }
        this.configManager = null;
        this.processorXmlNodes = null;
    }
}

