/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.mvc.handlermapping;

import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.tinygroup.commons.tools.AnnotationUtils;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.weblayer.mvc.HandlerExecutionChain;
import org.tinygroup.weblayer.mvc.MappingClassModel;
import org.tinygroup.weblayer.mvc.MappingMethodModel;
import org.tinygroup.weblayer.mvc.annotation.RequestMapping;
import org.tinygroup.weblayer.mvc.annotation.View;
import org.tinygroup.weblayer.mvc.handlermapping.AbstractHandlerMapping;
import org.tinygroup.weblayer.util.TinyPathMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationHandlerMapping
extends AbstractHandlerMapping {
    private TinyPathMatcher pathMatcher = new TinyPathMatcher();
    private static final Logger logger = LoggerFactory.getLogger(AnnotationHandlerMapping.class);

    @Override
    public void init() {
        super.init();
        Set<Class> mappingClassModels = this.getManager().getMappingClasses();
        logger.logMessage(LogLevel.INFO, "tiny-mvc \u5f00\u59cb\u521d\u59cb\u5316\u64cd\u4f5c");
        for (Class clazz : mappingClassModels) {
            MappingClassModel model = this.getManager().getMappingModelWithClass(clazz);
            RequestMapping mapping = model.getClassMapping();
            LinkedHashSet urls = new LinkedHashSet();
            if (mapping != null) {
                String[] typeLevelPatterns = mapping.value();
                if (typeLevelPatterns.length > 0) {
                    String[] methodLevelPatterns = this.determineUrlsForHandlerMethods(model, true);
                    for (String typeLevelPattern : typeLevelPatterns) {
                        if (!typeLevelPattern.startsWith("/")) {
                            typeLevelPattern = "/" + typeLevelPattern;
                        }
                        for (String methodLevelPattern : methodLevelPatterns) {
                            MappingMethodModel methodModel = model.removeMappingMethodWithUrlPattern(methodLevelPattern);
                            String combinedPattern = this.pathMatcher.combine(typeLevelPattern, methodLevelPattern);
                            model.putUrlMapping(combinedPattern, methodModel);
                            this.getManager().putUrlMapping(combinedPattern, model);
                        }
                    }
                    continue;
                }
                this.determineUrlsForHandlerMethods(model, false);
                continue;
            }
            this.determineUrlsForHandlerMethods(model, false);
        }
        logger.logMessage(LogLevel.INFO, "tiny-mvc \u521d\u59cb\u5316\u64cd\u4f5c\u7ed3\u675f");
    }

    @Override
    public HandlerExecutionChain getHandler(String requestUrl) throws Exception {
        return this.getManager().getMappingModelWithUrl(requestUrl);
    }

    private String[] determineUrlsForHandlerMethods(MappingClassModel model, boolean hasTypeLevelMapping) {
        LinkedHashSet<String> urls = new LinkedHashSet<String>();
        List<MappingMethodModel> methodModels = model.getMappingMethodModels();
        for (MappingMethodModel methodModel : methodModels) {
            LinkedHashSet<String> urlPatterns = new LinkedHashSet<String>();
            RequestMapping mapping = methodModel.getMethodMapping();
            if (mapping != null) {
                String[] mappedPatterns = mapping.value();
                if (mappedPatterns.length > 0) {
                    for (String mappedPattern : mappedPatterns) {
                        if (!hasTypeLevelMapping && !mappedPattern.startsWith("/")) {
                            mappedPattern = "/" + mappedPattern;
                        }
                        this.addUrlsForPath(urlPatterns, mappedPattern);
                        this.addUrlsForPath(urls, mappedPattern);
                    }
                } else if (hasTypeLevelMapping) {
                    urls.add(null);
                    urlPatterns.add(null);
                }
            }
            model.putUrlMappings(urlPatterns, methodModel);
            this.getManager().putUrlMappings(urlPatterns, model);
            Method method = methodModel.getMapMethod();
            View view = (View)AnnotationUtils.findAnnotation((Method)method, View.class);
            if (view == null) continue;
            methodModel.setView(view);
        }
        return StringUtil.toStringArray(urls);
    }

    private void addUrlsForPath(Set<String> urls, String path) {
        urls.add(path);
    }
}

