/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.tinyprocessor;

import java.util.UUID;
import org.tinygroup.cepcore.EventProcessor;
import org.tinygroup.context.Context;
import org.tinygroup.event.Event;
import org.tinygroup.event.ServiceRequest;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.plugin.PluginManager;
import org.tinygroup.weblayer.AbstractTinyProcessor;
import org.tinygroup.weblayer.WebContext;

public class LogicFlowTinyProcessor
extends AbstractTinyProcessor {
    private Logger logger = LoggerFactory.getLogger(LogicFlowTinyProcessor.class);
    PluginManager pluginManager;

    public void setPluginManager(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public void reallyProcess(String urlString, WebContext context) {
        this.logger.logMessage(LogLevel.INFO, "{}\u5f00\u59cb\u5904\u7406", new Object[]{urlString});
        EventProcessor channel = (EventProcessor)this.pluginManager.getService(this.pluginManager.getPluginInfo("simplechannel"), "simplechannel");
        String serviceId = this.getRequestId(urlString);
        Event event = new Event();
        event.setEventId(UUID.randomUUID().toString());
        ServiceRequest serviceRequest = new ServiceRequest();
        serviceRequest.setContext((Context)context);
        serviceRequest.setServiceId(serviceId);
        serviceRequest.setName(serviceId);
        event.setServiceRequest(serviceRequest);
        channel.process(event);
        this.logger.logMessage(LogLevel.INFO, "{}\u5904\u7406\u7ed3\u675f", new Object[]{urlString});
    }

    public String getRequestId(String urlString) {
        int lastDot = urlString.lastIndexOf(".");
        int lastSlash = urlString.lastIndexOf("/");
        return urlString.substring(lastSlash + 1, lastDot);
    }
}

