/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.util;

import java.beans.PropertyEditor;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.InitializingBean;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.commons.tools.ObjectUtil;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.filter.NameFilter;
import org.tinygroup.springutil.SpringUtil;
import org.tinygroup.weblayer.webcontext.parser.util.BeanWrapperImpl;
import org.tinygroup.xmlparser.node.XmlNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserXmlNodeUtil {
    private static final String BEAN_NAME = "bean-name";
    private static BeanWrapperImpl beanWrapper = new BeanWrapperImpl();

    public static <T> T[] parseConfigToArray(String subNodeName, XmlNode node, Class<T> clazz) {
        List subNodes;
        Assert.assertNotNull((Object)node, (String)"\u89e3\u6790\u7684\u8282\u70b9\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        NameFilter nameFilter = new NameFilter((Node)node);
        if (subNodeName != null && !CollectionUtil.isEmpty((Collection)(subNodes = nameFilter.findNodeList(subNodeName)))) {
            Object[] array = (Object[])Array.newInstance(clazz, subNodes.size());
            for (int i = 0; i < subNodes.size(); ++i) {
                T object = ParserXmlNodeUtil.newInstance(((XmlNode)subNodes.get(i)).getAttribute(BEAN_NAME), clazz);
                array[i] = object;
            }
            return array;
        }
        return null;
    }

    public static <T> T[] parseConfigToArray(String subNodeName, XmlNode node, Class<T> clazz, String ... attributeNames) {
        List subNodes;
        Assert.assertNotNull((Object)node, (String)"\u89e3\u6790\u7684\u8282\u70b9\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        NameFilter nameFilter = new NameFilter((Node)node);
        if (subNodeName != null && !CollectionUtil.isEmpty((Collection)(subNodes = nameFilter.findNodeList(subNodeName)))) {
            Object[] array = (Object[])Array.newInstance(clazz, subNodes.size());
            for (int i = 0; i < subNodes.size(); ++i) {
                array[i] = ParserXmlNodeUtil.parseConfigToObject(null, null, (XmlNode)subNodes.get(i), clazz, attributeNames);
            }
            return array;
        }
        return null;
    }

    public static <T> T[] parseConfigToArray(String subNodeName, String propertyNode, XmlNode node, Class<T> clazz) {
        List subNodes;
        Assert.assertNotNull((Object)node, (String)"\u89e3\u6790\u7684\u8282\u70b9\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        NameFilter nameFilter = new NameFilter((Node)node);
        if (subNodeName != null && !CollectionUtil.isEmpty((Collection)(subNodes = nameFilter.findNodeList(subNodeName)))) {
            Object[] array = (Object[])Array.newInstance(clazz, subNodes.size());
            for (int i = 0; i < subNodes.size(); ++i) {
                XmlNode xmlNode = (XmlNode)subNodes.get(i);
                array[i] = ParserXmlNodeUtil.parseConfigToObject(null, propertyNode, xmlNode, clazz, new String[0]);
            }
            return array;
        }
        return null;
    }

    public static <T> T parseConfigToObject(String subNodeName, XmlNode node, Class<T> clazz) {
        NameFilter nameFilter;
        XmlNode subNode;
        Assert.assertNotNull((Object)node, (String)"\u89e3\u6790\u7684\u8282\u70b9\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        XmlNode xmlNode = node;
        if (subNodeName != null && !ObjectUtil.isEmptyObject((Object)(subNode = (XmlNode)(nameFilter = new NameFilter((Node)node)).findNode(subNodeName)))) {
            xmlNode = subNode;
        }
        return ParserXmlNodeUtil.newInstance(xmlNode.getAttribute(BEAN_NAME), clazz);
    }

    public static <T> T parseConfigToObject(String subNodeName, String propertyNode, XmlNode node, Class<T> clazz, String ... attributeNames) {
        NameFilter nameFilter;
        XmlNode subNode;
        Assert.assertNotNull((Object)node, (String)"\u89e3\u6790\u7684\u8282\u70b9\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        XmlNode xmlNode = node;
        if (subNodeName != null && !ObjectUtil.isEmptyObject((Object)(subNode = (XmlNode)(nameFilter = new NameFilter((Node)node)).findNode(subNodeName)))) {
            xmlNode = subNode;
        }
        if (propertyNode != null) {
            return ParserXmlNodeUtil.createObjectWithProperty(clazz, xmlNode, propertyNode);
        }
        return ParserXmlNodeUtil.createObject(clazz, xmlNode, attributeNames);
    }

    private static <T> T createObject(Class<T> clazz, XmlNode subNode, String ... attributeNames) {
        T object = ParserXmlNodeUtil.newInstance(subNode.getAttribute(BEAN_NAME), clazz);
        HashMap properties = CollectionUtil.createHashMap();
        for (String attribute : attributeNames) {
            try {
                String value = subNode.getAttribute(attribute);
                if (value == null) {
                    NameFilter nameFilter2 = new NameFilter((Node)subNode);
                    List valueNodes = nameFilter2.findNodeList(attribute);
                    StringBuffer buffer = new StringBuffer();
                    if (!CollectionUtil.isEmpty((Collection)valueNodes)) {
                        for (int j = 0; j < valueNodes.size(); ++j) {
                            buffer.append(((XmlNode)valueNodes.get(j)).getContent());
                            if (j == valueNodes.size() - 1) continue;
                            buffer.append(",");
                        }
                        value = buffer.toString();
                    }
                }
                properties.put(attribute, value);
            }
            catch (Exception e) {
                throw new RuntimeException("\u8bbe\u7f6e\u5bf9\u8c61\u5c5e\u6027\u51fa\u9519", e);
            }
        }
        return ParserXmlNodeUtil.setAttribute(object, properties);
    }

    private static <T> T createObjectWithProperty(Class<T> clazz, XmlNode node, String propertyNode) {
        T object = ParserXmlNodeUtil.newInstance(node.getAttribute(BEAN_NAME), clazz);
        HashMap properties = CollectionUtil.createHashMap();
        NameFilter propertyFilter = new NameFilter((Node)node);
        List subNodes = propertyFilter.findNodeList(propertyNode);
        for (XmlNode subNode : subNodes) {
            String value = subNode.getAttribute("value");
            if (value == null) {
                value = subNode.getContent();
            }
            properties.put(subNode.getAttribute("name"), value);
        }
        return ParserXmlNodeUtil.setAttribute(object, properties);
    }

    private static <T> T setAttribute(T object, Map<String, String> properties) {
        beanWrapper.setWrappedInstance(object);
        for (String attribute : properties.keySet()) {
            try {
                String value = properties.get(attribute);
                beanWrapper.setPropertyValue(attribute, value);
            }
            catch (Exception e) {
                throw new RuntimeException("\u8bbe\u7f6e\u5bf9\u8c61\u5c5e\u6027\u51fa\u9519", e);
            }
        }
        if (object instanceof InitializingBean) {
            try {
                ((InitializingBean)object).afterPropertiesSet();
            }
            catch (Exception e) {
                throw new RuntimeException("initializingBean error", e);
            }
        }
        return object;
    }

    public static <T> Map<String, T> parseConfigToMap(String subNodeName, String attributeKeyName, XmlNode node, Class<T> clazz) {
        NameFilter nameFilter;
        List subNodes;
        Assert.assertNotNull((Object)node, (String)"\u89e3\u6790\u7684\u8282\u70b9\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.assertNotNull((Object)attributeKeyName, (String)"\u89e3\u6790\u7684\u8282\u70b9\u5c5e\u6027\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (subNodeName != null && !CollectionUtil.isEmpty((Collection)(subNodes = (nameFilter = new NameFilter((Node)node)).findNodeList(subNodeName)))) {
            LinkedHashMap<String, T> map = new LinkedHashMap<String, T>();
            for (XmlNode subNode : subNodes) {
                T object = ParserXmlNodeUtil.newInstance(subNode.getAttribute(BEAN_NAME), clazz);
                map.put(subNode.getAttribute(attributeKeyName), object);
            }
            return map;
        }
        return null;
    }

    public static Map<String, String> parseConfigToMap(String subNodeName, String attributeKeyName, String attributeValueName, XmlNode node) {
        Assert.assertNotNull((Object)node, (String)"\u89e3\u6790\u7684\u8282\u70b9\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.assertNotNull((Object)attributeKeyName, (String)"\u89e3\u6790\u7684\u8282\u70b9\u5c5e\u6027\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.assertNotNull((Object)attributeValueName, (String)"\u89e3\u6790\u7684\u8282\u70b9\u5c5e\u6027\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (subNodeName != null) {
            NameFilter nameFilter = new NameFilter((Node)node);
            List subNodes = nameFilter.findNodeList(subNodeName);
            ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
            if (!CollectionUtil.isEmpty((Collection)subNodes)) {
                for (XmlNode subNode : subNodes) {
                    map.put(subNode.getAttribute(attributeKeyName), subNode.getAttribute(attributeValueName));
                }
            }
            return map;
        }
        return null;
    }

    public static String getAttributeValueWithSubNode(String subNodeName, String attribute, XmlNode xmlNode) {
        Assert.assertNotNull((Object)xmlNode, (String)"\u89e3\u6790\u7684\u8282\u70b9\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.assertNotNull((Object)attribute, (String)"\u89e3\u6790\u7684\u8282\u70b9\u5c5e\u6027\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        NameFilter nameFilter = new NameFilter((Node)xmlNode);
        XmlNode node = xmlNode;
        if (subNodeName != null) {
            node = (XmlNode)nameFilter.findNode(subNodeName);
        }
        if (!ObjectUtil.isEmptyObject((Object)node)) {
            return node.getAttribute(attribute);
        }
        return null;
    }

    public static String getAttributeValue(String attribute, XmlNode node) {
        return ParserXmlNodeUtil.getAttributeValueWithSubNode(null, attribute, node);
    }

    public static boolean existNode(String nodeName, XmlNode node) {
        Assert.assertNotNull((Object)node, (String)"\u89e3\u6790\u7684\u8282\u70b9\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        NameFilter nameFilter = new NameFilter((Node)node);
        return nameFilter.findNode(nodeName) != null;
    }

    private static <T> T newInstance(String bean, Class<T> clazz) {
        Object instance = null;
        try {
            instance = SpringUtil.getBean((String)bean, clazz);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (instance == null) {
            try {
                instance = clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("\u5b9e\u4f8b\u5316\u51fa\u9519", e);
            }
        }
        return (T)instance;
    }

    static {
        Map customEditors = SpringUtil.getCustomEditors();
        Set keySet = customEditors.keySet();
        for (Object key : keySet) {
            Class requiredType = (Class)key;
            if (customEditors.get(requiredType) instanceof Class) {
                try {
                    beanWrapper.registerCustomEditor(requiredType, (PropertyEditor)((Class)customEditors.get(requiredType)).newInstance());
                }
                catch (Exception e) {
                    throw new RuntimeException("\u6ce8\u518c\u5ba2\u6237\u81ea\u5b9a\u4e49\u7c7b\u578b\u8f6c\u6362\u51fa\u9519", e);
                }
            }
            if (!(customEditors.get(requiredType) instanceof PropertyEditor)) continue;
            beanWrapper.registerCustomEditor(requiredType, (PropertyEditor)customEditors.get(requiredType));
        }
    }
}

