/**
 *  Copyright (c) 1997-2013, tinygroup.org (luo_guo@live.cn).
 *
 *  Licensed under the GPL, Version 3.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       http://www.gnu.org/licenses/gpl.html
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * --------------------------------------------------------------------------
 *  版权 (c) 1997-2013, tinygroup.org (luo_guo@live.cn).
 *
 *  本开源软件遵循 GPL 3.0 协议;
 *  如果您不遵循此协议，则不被允许使用此文件。
 *  你可以从下面的地址获取完整的协议文本
 *
 *       http://www.gnu.org/licenses/gpl.html
 */
package org.tinygroup.weblayer.tinyprocessor;

import java.util.UUID;

import org.tinygroup.cepcore.EventProcessor;
import org.tinygroup.event.Event;
import org.tinygroup.event.ServiceRequest;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.plugin.PluginManager;
import org.tinygroup.weblayer.AbstractTinyProcessor;
import org.tinygroup.weblayer.WebContext;

/**
 * 逻辑流flow-processor
 * @author renhui
 *
 */
public class LogicFlowTinyProcessor extends AbstractTinyProcessor {

	private Logger logger = LoggerFactory.getLogger(LogicFlowTinyProcessor.class);

	PluginManager pluginManager;

	public void setPluginManager(PluginManager pluginManager) {
		this.pluginManager = pluginManager;
	}

	@Override
	public void reallyProcess(String urlString, WebContext context) {
		logger.logMessage(LogLevel.INFO, "{}开始处理",urlString);
		EventProcessor channel = (EventProcessor) pluginManager.getService(
				pluginManager.getPluginInfo("simplechannel"), "simplechannel");
		String serviceId = getRequestId(urlString);
		Event event = new Event();
		event.setEventId(UUID.randomUUID().toString());
		ServiceRequest serviceRequest = new ServiceRequest();
		serviceRequest.setContext(context);
		serviceRequest.setServiceId(serviceId);
		serviceRequest.setName(serviceId);
		event.setServiceRequest(serviceRequest);
		channel.process(event);
		logger.logMessage(LogLevel.INFO, "{}处理结束",urlString);

	}

	public String getRequestId(String urlString) {
		int lastDot = urlString.lastIndexOf(".");
		int lastSlash = urlString.lastIndexOf("/");
		return urlString.substring(lastSlash + 1, lastDot);
	}

}
