/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.springutil.SpringUtil;
import org.tinygroup.weblayer.FilterWrapper;
import org.tinygroup.weblayer.TinyFilterHandler;
import org.tinygroup.weblayer.TinyFilterManager;
import org.tinygroup.weblayer.TinyProcessorManager;
import org.tinygroup.weblayer.impl.WebContextImpl;
import org.tinygroup.weblayer.listener.ServletContextHolder;

public class TinyHttpFilter
implements Filter {
    private static final String EXCLUDE_PATH = "excludePath";
    private static final Logger logger = LoggerFactory.getLogger(TinyHttpFilter.class);
    private TinyProcessorManager tinyProcessorManager;
    private TinyFilterManager tinyFilterManager;
    private List<Pattern> excludePatterns = new ArrayList<Pattern>();
    private FilterWrapper wrapper;

    public void destroy() {
        this.destoryTinyProcessors();
        this.destoryTinyFilters();
        this.wrapper = null;
    }

    private void destoryTinyFilters() {
        this.tinyFilterManager.destoryTinyResources();
        this.tinyFilterManager = null;
    }

    private void destoryTinyProcessors() {
        this.tinyProcessorManager.destoryTinyResources();
        this.tinyProcessorManager = null;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        WebContextImpl context = new WebContextImpl();
        context.put("TINY_CONTEXT_PATH", request.getContextPath());
        context.init(request, response, ServletContextHolder.getServletContext());
        String servletPath = request.getServletPath();
        if (servletPath == null || servletPath.length() == 0) {
            servletPath = request.getPathInfo();
        }
        if (this.isExcluded(servletPath)) {
            logger.logMessage(LogLevel.DEBUG, "\u8bf7\u6c42\u8def\u5f84:<{}>,\u88ab\u62d2\u7edd", new Object[]{servletPath});
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        TinyFilterHandler hander = new TinyFilterHandler(servletPath, filterChain, context, this.tinyFilterManager, this.tinyProcessorManager);
        if (this.wrapper != null) {
            this.wrapper.filterWrapper(context, hander);
        } else {
            hander.tinyFilterProcessor();
        }
    }

    private boolean isExcluded(String servletPath) {
        for (Pattern pattern : this.excludePatterns) {
            if (!pattern.matcher(servletPath).matches()) continue;
            return true;
        }
        return false;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        logger.logMessage(LogLevel.INFO, "filter\u521d\u59cb\u5316\u5f00\u59cb...");
        this.initExcludePattern(filterConfig);
        this.initTinyFilters();
        this.initTinyFilterWrapper();
        this.initTinyProcessors();
        logger.logMessage(LogLevel.INFO, "filter\u521d\u59cb\u5316\u7ed3\u675f...");
    }

    private void initTinyFilterWrapper() {
        this.wrapper = this.tinyFilterManager.getFilterWrapper();
    }

    private void initExcludePattern(FilterConfig filterConfig) {
        String excludePath = filterConfig.getInitParameter(EXCLUDE_PATH);
        if (excludePath != null) {
            String[] excludeArray;
            for (String path : excludeArray = excludePath.split(",")) {
                this.excludePatterns.add(Pattern.compile(path));
            }
        }
    }

    private void initTinyFilters() {
        this.tinyFilterManager = (TinyFilterManager)SpringUtil.getBean((String)"tinyFilterManager");
        this.tinyFilterManager.initTinyResources();
    }

    private void initTinyProcessors() {
        this.tinyProcessorManager = (TinyProcessorManager)SpringUtil.getBean((String)"tinyProcessorManager");
        this.tinyProcessorManager.initTinyResources();
    }
}

