/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.listener;

import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.tinygroup.application.Application;
import org.tinygroup.application.ApplicationProcessor;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.filter.NameFilter;
import org.tinygroup.springutil.SpringUtil;
import org.tinygroup.weblayer.listener.ServletContextHolder;
import org.tinygroup.weblayer.listener.TinyServletContext;
import org.tinygroup.xmlparser.node.XmlNode;

public class TinyListenerApplicationProcessor
implements ApplicationProcessor {
    private static final String CONTEXT_PARAM = "context-param";
    private static final String LISTENER_BEAN = "listener-bean";
    private static final String LISTENER_NODE_NAME = "tiny-listener";
    private XmlNode tinyListenerNode;
    private Application application;
    private List<ServletContextListener> listeners = CollectionUtil.createArrayList();
    private TinyServletContext servletContext;
    private ServletContextEvent event;

    public String getNodeName() {
        return LISTENER_NODE_NAME;
    }

    public void setConfiguration(XmlNode xmlNode) {
        this.tinyListenerNode = xmlNode;
    }

    public XmlNode getConfiguration() {
        return this.tinyListenerNode;
    }

    public void start() {
        this.initListeners();
        this.startListeners();
    }

    private void startListeners() {
        for (ServletContextListener listener : this.listeners) {
            listener.contextInitialized(this.event);
        }
    }

    private void initListeners() {
        NameFilter nameFilter = new NameFilter((Node)this.tinyListenerNode);
        List nodes = nameFilter.findNodeList(LISTENER_BEAN);
        for (XmlNode node : nodes) {
            ServletContextListener listener = (ServletContextListener)SpringUtil.getBean((String)node.getAttribute("name"));
            this.listeners.add(listener);
        }
        NameFilter parameterFilter = new NameFilter((Node)this.tinyListenerNode);
        List parameterNodes = parameterFilter.findNodeList(CONTEXT_PARAM);
        this.servletContext = new TinyServletContext(ServletContextHolder.getServletContext());
        ServletContextHolder.setServletContext(this.servletContext);
        this.event = new ServletContextEvent((ServletContext)this.servletContext);
        for (XmlNode node : parameterNodes) {
            String name = node.getAttribute("name");
            String value = node.getAttribute("value");
            this.servletContext.setInitParameter(name, value);
        }
    }

    public void stop() {
        this.stopListeners();
    }

    private void stopListeners() {
        for (ServletContextListener listener : this.listeners) {
            listener.contextDestroyed(this.event);
        }
    }

    public void setApplication(Application application) {
        this.application = application;
    }
}

