/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.servlet;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tinygroup.context.Context;
import org.tinygroup.fileresolver.FullContextFileRepository;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.springutil.SpringUtil;
import org.tinygroup.velocity.VelocityHelper;
import org.tinygroup.velocity.impl.VelocityHelperImpl;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.weblayer.impl.WebContextImpl;
import org.tinygroup.weblayer.listener.ServletContextHolder;

public class VelocityLayoutViewServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(VelocityLayoutViewServlet.class);
    private static final String PAGELET_EXT_FILE_NAME = ".pagelet";
    private static final String PAGE_EXT_FILE_NAME = ".page";
    private String templeteWithLayout = ".page";
    private String template = ".pagelet";
    private VelocityHelper velocityHelper;
    private FullContextFileRepository fullContextFileRepository;
    private static final long serialVersionUID = -1514050556632003280L;

    public void init(ServletConfig config) throws ServletException {
        this.fullContextFileRepository = (FullContextFileRepository)SpringUtil.getBean((String)"fullContextFileRepository");
        VelocityHelperImpl velocityHelperImpl = (VelocityHelperImpl)SpringUtil.getBean((String)"velocityHelper");
        this.velocityHelper = velocityHelperImpl;
        this.templeteWithLayout = config.getInitParameter("templeteWithLayoutExtFileName");
        this.template = config.getInitParameter("templateExtFileName");
        if (this.templeteWithLayout == null || this.templeteWithLayout.length() == 0) {
            this.templeteWithLayout = PAGE_EXT_FILE_NAME;
        }
        if (this.template == null || this.template.length() == 0) {
            this.template = PAGELET_EXT_FILE_NAME;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            FileObject fileObject;
            long startTime = System.currentTimeMillis();
            String servletPath = request.getServletPath();
            if (servletPath == null || servletPath.length() == 0) {
                servletPath = request.getPathInfo();
            }
            boolean isPagelet = false;
            if (servletPath.endsWith(PAGELET_EXT_FILE_NAME)) {
                isPagelet = true;
                servletPath = servletPath.substring(0, servletPath.length() - PAGELET_EXT_FILE_NAME.length()) + PAGE_EXT_FILE_NAME;
            }
            if ((fileObject = this.fullContextFileRepository.getFileObject(servletPath)) != null) {
                WebContextImpl webContent = new WebContextImpl();
                webContent.put("uiengine", SpringUtil.getBean((String)"uiComponentManager"));
                webContent.init(request, response, ServletContextHolder.getServletContext());
                if (isPagelet) {
                    this.velocityHelper.processTempleate((Context)webContent, (Writer)response.getWriter(), servletPath);
                } else {
                    this.velocityHelper.processTempleateWithLayout((Context)webContent, (Writer)response.getWriter(), servletPath);
                }
                long endTime = System.currentTimeMillis();
                logger.logMessage(LogLevel.INFO, "\u8def\u5f84<{}>\u5904\u7406\u65f6\u95f4\uff1a{}ms", new Object[]{servletPath, endTime - startTime});
                return;
            }
            logger.logMessage(LogLevel.ERROR, "\u8def\u5f84<{}>\u5bf9\u5e94\u7684\u8d44\u6e90\u4e0d\u80fd\u88ab\u627e\u5230\u3002", new Object[]{servletPath});
        }
        catch (Exception e) {
            logger.errorMessage(e.getMessage(), (Throwable)e);
        }
        response.sendError(404);
    }
}

