/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tinygroup.application.Application;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.commons.tools.ObjectUtil;
import org.tinygroup.context.Context;
import org.tinygroup.context.impl.ContextImpl;
import org.tinygroup.springutil.SpringUtil;
import org.tinygroup.weblayer.WebContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWebContextWrapper
extends ContextImpl
implements WebContext {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private ServletContext servletContext;
    private WebContext wrappedContext;
    private Map<String, WebContextScope> scopes = new HashMap<String, WebContextScope>();

    public AbstractWebContextWrapper() {
        this.scopes.put("requestScope", new RequestScope());
        this.scopes.put("sessionScope", new SessionScope());
        this.scopes.put("applicationScope", new SessionScope());
    }

    public AbstractWebContextWrapper(WebContext wrappedContext) {
        this.scopes.put("requestScope", new RequestScope());
        this.scopes.put("sessionScope", new SessionScope());
        this.scopes.put("applicationScope", new SessionScope());
        Assert.assertNotNull((Object)wrappedContext, (String)"wrappedContext", (Object[])new Object[0]);
        this.wrappedContext = wrappedContext;
        this.request = wrappedContext.getRequest();
        this.response = wrappedContext.getResponse();
        this.servletContext = wrappedContext.getServletContext();
    }

    @Override
    public HttpServletResponse getResponse() {
        return this.response;
    }

    @Override
    public void setResponse(HttpServletResponse response) {
        this.response = response;
        super.put("httpServletResponse", (Object)response);
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.request;
    }

    private <T> T findInRequset(String name) {
        if (this.request != null) {
            Object[] temp;
            Object result = this.request.getAttribute(name);
            if (!ObjectUtil.isEmptyObject((Object)result)) {
                return (T)result;
            }
            result = this.request.getParameterValues(name);
            if (!ObjectUtil.isEmptyObject((Object)result) && result.getClass().isArray() && (temp = (Object[])result).length == 1) {
                result = temp[0];
            }
            if (!ObjectUtil.isEmptyObject((Object)result)) {
                return (T)result;
            }
            result = this.request.getSession().getAttribute(name);
            if (!ObjectUtil.isEmptyObject((Object)result)) {
                return (T)result;
            }
            if (this.request.getCookies() != null) {
                for (Cookie cookie : this.request.getCookies()) {
                    if (!cookie.getName().equals(name)) continue;
                    result = cookie.getValue();
                    return (T)result;
                }
            }
            if (!ObjectUtil.isEmptyObject((Object)(result = this.request.getHeader(name)))) {
                return (T)result;
            }
        }
        return null;
    }

    public <T> T get(String name) {
        T result = this.getFromWrapperContext(name, this);
        if (!ObjectUtil.isEmptyObject(result)) {
            return result;
        }
        result = this.findInRequset(name);
        if (!ObjectUtil.isEmptyObject(result)) {
            return result;
        }
        return null;
    }

    protected <T> T getFromWrapperContext(String name, WebContext webContext) {
        T result = this.getFromSubContext(name, webContext);
        if (!ObjectUtil.isEmptyObject(result)) {
            return result;
        }
        if (webContext.getWrappedWebContext() != null && !ObjectUtil.isEmptyObject(result = this.getFromWrapperContext(name, webContext.getWrappedWebContext()))) {
            return result;
        }
        return null;
    }

    private <T> T getFromSubContext(String name, Context context) {
        HashMap nodeMap = new HashMap();
        return (T)this.findNodeMap(name, context, nodeMap);
    }

    @Override
    public void setRequest(HttpServletRequest request) {
        this.request = request;
        super.put("httpServletRequest", (Object)request);
    }

    @Override
    public void init(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        this.setRequest(request);
        this.setResponse(response);
        this.setServletContext(servletContext);
        this.putRequestInfo(request);
        Application application = (Application)SpringUtil.getBean((String)"application");
        this.putContext("TINY_APPLICATION_CONTEXT", application.getContext());
    }

    private void putRequestInfo(HttpServletRequest request) {
        this.put("tinyRequestRemoteAddr", request.getRemoteAddr());
        this.put("tinyRequestRemoteHost", request.getRemoteHost());
        this.put("tinyRequestRemoteUser", request.getRemoteUser());
        this.put("tinyRequestScheme", request.getScheme());
        this.put("tinyRequestServerName", request.getServerName());
        this.put("tinyRequestServletPath", request.getServletPath());
        this.put("tinyRequestServerPort", request.getServerPort());
        this.put("tinyRequestAuthType", request.getAuthType());
        this.put("tinyRequestEncoding", request.getCharacterEncoding());
        this.put("tinyRequestContentType", request.getContentType());
        this.put("tinyRequestContextPath", request.getContextPath());
        this.put("tinyRequestLocalAddr", request.getLocalAddr());
        this.put("tinyRequestLocalName", request.getLocalName());
        this.put("tinyRequestLocalPort", request.getLocalPort());
        this.put("tinyRequestPathInfo", request.getPathInfo());
        this.put("tinyRequestLocalName", request.getPathTranslated());
        this.put("tinyRequestProtocol", request.getProtocol());
        this.put("tinyRequestQueryString", request.getQueryString());
        this.put("tinyRequestRequestURI", request.getRequestURI());
    }

    @Override
    public WebContext getWrappedWebContext() {
        return this.wrappedContext;
    }

    public WebContext getWrappedWebContext(String contextName) {
        return (WebContext)this.getSubContext(contextName);
    }

    public void putSubWebContext(String contextName, WebContext webContext) {
        this.putContext(contextName, webContext);
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
        super.put("httpServletContext", (Object)servletContext);
    }

    @Override
    public void setObject(String scope, String key, Object value) {
        WebContextScope webContextScope = this.scopes.get(scope);
        if (webContextScope != null) {
            webContextScope.setObject(key, value);
            return;
        }
        throw new RuntimeException(String.format("\u627e\u4e0d\u5230%s\u5bf9\u5e94\u7684\u8bf7\u6c42\u8303\u56f4", scope));
    }

    @Override
    public Object getObject(String scope, String key) {
        WebContextScope webContextScope = this.scopes.get(scope);
        if (webContextScope != null) {
            return webContextScope.getObject(key);
        }
        throw new RuntimeException(String.format("\u627e\u4e0d\u5230%s\u5bf9\u5e94\u7684\u8bf7\u6c42\u8303\u56f4", scope));
    }

    class ApplicationScope
    implements WebContextScope {
        private String scope = "applicationScope";

        ApplicationScope() {
        }

        public String getScope() {
            return this.scope;
        }

        public void setObject(String key, Object value) {
            AbstractWebContextWrapper.this.getServletContext().setAttribute(key, value);
        }

        public Object getObject(String key) {
            return AbstractWebContextWrapper.this.getServletContext().getAttribute(key);
        }
    }

    class SessionScope
    implements WebContextScope {
        private String scope = "sessionScope";

        SessionScope() {
        }

        public String getScope() {
            return this.scope;
        }

        public void setObject(String key, Object value) {
            AbstractWebContextWrapper.this.getRequest().getSession().setAttribute(key, value);
        }

        public Object getObject(String key) {
            return AbstractWebContextWrapper.this.getRequest().getSession().getAttribute(key);
        }
    }

    class RequestScope
    implements WebContextScope {
        private String scope = "requestScope";

        RequestScope() {
        }

        public String getScope() {
            return this.scope;
        }

        public void setObject(String key, Object value) {
            AbstractWebContextWrapper.this.getRequest().setAttribute(key, value);
        }

        public Object getObject(String key) {
            return AbstractWebContextWrapper.this.getRequest().getAttribute(key);
        }
    }

    static interface WebContextScope {
        public String getScope();

        public void setObject(String var1, Object var2);

        public Object getObject(String var1);
    }
}

