/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.parser.util;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class GenericTypeAwarePropertyDescriptor
extends PropertyDescriptor {
    private final Class beanClass;
    private final Method readMethod;
    private final Method writeMethod;
    private final Class propertyEditorClass;
    private Class propertyType;
    private MethodParameter writeMethodParameter;

    public GenericTypeAwarePropertyDescriptor(Class beanClass, String propertyName, Method readMethod, Method writeMethod, Class propertyEditorClass) throws IntrospectionException {
        super(propertyName, null, null);
        this.beanClass = beanClass;
        Method readMethodToUse = BridgeMethodResolver.findBridgedMethod((Method)readMethod);
        Method writeMethodToUse = BridgeMethodResolver.findBridgedMethod((Method)writeMethod);
        if (writeMethodToUse == null && readMethodToUse != null) {
            writeMethodToUse = ClassUtils.getMethodIfAvailable((Class)this.beanClass, (String)("set" + StringUtils.capitalize((String)this.getName())), (Class[])new Class[]{readMethodToUse.getReturnType()});
        }
        this.readMethod = readMethodToUse;
        this.writeMethod = writeMethodToUse;
        this.propertyEditorClass = propertyEditorClass;
    }

    public Method getReadMethod() {
        return this.readMethod;
    }

    public Method getWriteMethod() {
        return this.writeMethod;
    }

    public Class getPropertyEditorClass() {
        return this.propertyEditorClass;
    }

    public synchronized Class getPropertyType() {
        if (this.propertyType == null) {
            MethodParameter writeMethodParam;
            this.propertyType = this.readMethod != null ? GenericTypeResolver.resolveReturnType((Method)this.readMethod, (Class)this.beanClass) : ((writeMethodParam = this.getWriteMethodParameter()) != null ? writeMethodParam.getParameterType() : super.getPropertyType());
        }
        return this.propertyType;
    }

    public synchronized MethodParameter getWriteMethodParameter() {
        if (this.writeMethod == null) {
            return null;
        }
        if (this.writeMethodParameter == null) {
            this.writeMethodParameter = new MethodParameter(this.writeMethod, 0);
            GenericTypeResolver.resolveParameterType((MethodParameter)this.writeMethodParameter, (Class)this.beanClass);
        }
        return this.writeMethodParameter;
    }
}

