/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.parser.valueparser.impl;

import javax.servlet.http.Cookie;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.weblayer.webcontext.parser.ParserWebContext;
import org.tinygroup.weblayer.webcontext.parser.valueparser.AbstractValueParser;
import org.tinygroup.weblayer.webcontext.parser.valueparser.CookieParser;

public class CookieParserImpl
extends AbstractValueParser
implements CookieParser {
    public CookieParserImpl(ParserWebContext webContext) {
        super(webContext);
        Cookie[] cookies = webContext.getRequest().getCookies();
        if (cookies != null) {
            logger.logMessage(LogLevel.DEBUG, "Number of Cookies {}", new Object[]{cookies.length});
            for (Cookie cookie : cookies) {
                String name = cookie.getName();
                String value = cookie.getValue();
                logger.logMessage(LogLevel.DEBUG, "Adding {}  =  {}", new Object[]{name, value});
                this.add(name, value);
            }
        }
    }

    public void setCookie(String name, String value) {
        this.setCookie(name, value, -1);
    }

    public void setCookie(String name, String value, int seconds_age) {
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(seconds_age);
        cookie.setDomain(this.getCookieDomain());
        cookie.setPath(this.getCookiePath());
        this.webContext.getResponse().addCookie(cookie);
    }

    protected String getCookieDomain() {
        String domain = StringUtil.defaultIfEmpty((String)this.webContext.getRequest().getServerName(), (String)"");
        String[] parts = StringUtil.split((String)domain, (String)".");
        int length = parts.length;
        if (length < 2) {
            return domain;
        }
        return "." + parts[length - 2] + "." + parts[length - 1];
    }

    protected String getCookiePath() {
        return StringUtil.defaultIfEmpty((String)this.webContext.getRequest().getContextPath(), (String)"/");
    }

    public void removeCookie(String name) {
        this.setCookie(name, " ", 0);
    }
}

