/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.session.impl;

import java.security.SecureRandom;
import java.util.Random;
import org.apache.commons.codec.binary.Base64;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.commons.tools.ObjectUtil;
import org.tinygroup.commons.tools.ToStringBuilder;
import org.tinygroup.support.BeanSupport;
import org.tinygroup.weblayer.webcontext.session.SessionIDGenerator;

public class RandomIDGenerator
extends BeanSupport
implements SessionIDGenerator {
    private Integer length;
    private Random rnd;

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    protected void init() {
        this.length = (Integer)ObjectUtil.defaultIfNull((Object)this.length, (Object)SESSION_ID_LENGTH_DEFAULT);
        try {
            this.rnd = new SecureRandom();
        }
        catch (Throwable e) {
            this.rnd = new Random();
        }
    }

    public String generateSessionID() {
        this.assertInitialized();
        byte[] bytes = new byte[(this.length + 3) / 4 * 3];
        this.rnd.nextBytes(bytes);
        byte[] b64Encoded = Base64.encodeBase64((byte[])bytes);
        StringBuilder buf = new StringBuilder(this.length);
        for (int i = 0; i < this.length; ++i) {
            char ch = (char)b64Encoded[i];
            switch (ch) {
                case '/': {
                    ch = '$';
                    break;
                }
                case '+': {
                    ch = '-';
                    break;
                }
                case '=': {
                    Assert.unreachableCode();
                }
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public String toString() {
        return new ToStringBuilder().append((Object)"RandomSessionIDGenerator[length=").append((Object)this.length).append((Object)"]").toString();
    }
}

