/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.util;

import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.tinygroup.weblayer.WebContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebContextUtil {
    private static final String REQUEST_CONTEXT_KEY = "_outer_webx3_request_context_";

    public static WebContext getWebContext(HttpServletRequest request) {
        return (WebContext)request.getAttribute(REQUEST_CONTEXT_KEY);
    }

    public static void setWebContext(WebContext WebContext2) {
        HttpServletRequest request = WebContext2.getRequest();
        request.setAttribute(REQUEST_CONTEXT_KEY, (Object)WebContext2);
    }

    public static void removeWebContext(HttpServletRequest request) {
        request.removeAttribute(REQUEST_CONTEXT_KEY);
    }

    public static <R extends WebContext> R findWebContext(HttpServletRequest request, Class<R> WebContextInterface) {
        return WebContextUtil.findWebContext(WebContextUtil.getWebContext(request), WebContextInterface);
    }

    public static <R extends WebContext> R findWebContext(WebContext webContext, Class<R> webContextInterface) {
        while (!webContextInterface.isInstance(webContext) && (webContext = webContext.getWrappedWebContext()) != null) {
        }
        return (R)((WebContext)webContextInterface.cast(webContext));
    }

    public static void registerRequestDestructionCallback(String name, Runnable callback) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        attributes.registerDestructionCallback(name, callback, 0);
    }
}

