/**
 *  Copyright (c) 1997-2013, tinygroup.org (luo_guo@live.cn).
 *
 *  Licensed under the GPL, Version 3.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       http://www.gnu.org/licenses/gpl.html
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * --------------------------------------------------------------------------
 *  版权 (c) 1997-2013, tinygroup.org (luo_guo@live.cn).
 *
 *  本开源软件遵循 GPL 3.0 协议;
 *  如果您不遵循此协议，则不被允许使用此文件。
 *  你可以从下面的地址获取完整的协议文本
 *
 *       http://www.gnu.org/licenses/gpl.html
 */
package org.tinygroup.weblayer.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.weblayer.TinyFilterHandler;

/**
 * 过滤器链接口的默认实现，不再往下传递调用,直接返回
 * 
 * @author renhui
 * 
 */
public class TinyFilterChain implements FilterChain {
	private List<Filter> filters = new ArrayList<Filter>();
	private int size;
	private int currentPosition = 0;
	private static final Logger logger = LoggerFactory
			.getLogger(TinyFilterChain.class);

	private TinyFilterHandler hander;

	public TinyFilterChain(List<Filter> filters, TinyFilterHandler hander) {
		this.filters = filters;
		size = filters.size();
		this.hander = hander;
	}

	public void doFilter(ServletRequest request, ServletResponse response)
			throws IOException, ServletException {
		currentPosition++;
		if (currentPosition <= size) {
			Filter nextFilter = filters.get(currentPosition - 1);
			logger.logMessage(LogLevel.DEBUG, "firing Filter:'{}'", nextFilter
					.getClass().getSimpleName());
			nextFilter.doFilter(request, response, this);
		} else {
			hander.tinyFilterProcessor();
		}
	}

	public String currentExcuteFilterName() {
		String filterName = null;
		Filter currentFilter = filters.get(currentPosition - 1);
		if (currentFilter != null) {
			filterName = currentFilter.getClass().getSimpleName();
		}
		return filterName;
	}
}
