/**
 *  Copyright (c) 1997-2013, tinygroup.org (luo_guo@live.cn).
 *
 *  Licensed under the GPL, Version 3.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       http://www.gnu.org/licenses/gpl.html
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * --------------------------------------------------------------------------
 *  版权 (c) 1997-2013, tinygroup.org (luo_guo@live.cn).
 *
 *  本开源软件遵循 GPL 3.0 协议;
 *  如果您不遵循此协议，则不被允许使用此文件。
 *  你可以从下面的地址获取完整的协议文本
 *
 *       http://www.gnu.org/licenses/gpl.html
 */
package org.tinygroup.weblayer.impl;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.Filter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.springutil.SpringUtil;
import org.tinygroup.weblayer.AbstractTinyFilter;
import org.tinygroup.weblayer.FilterWrapper;
import org.tinygroup.weblayer.TinyFilterHandler;
import org.tinygroup.weblayer.WebContext;

/**
 * tiny-filter的包装类
 * 
 * @author renhui
 * 
 */
public class TinyFilterWrapper extends AbstractTinyFilter implements
		FilterWrapper {

	private static final String SPLIT_CHAR = ",";

	private List<Filter> filters = new ArrayList<Filter>();

	private static final Logger logger = LoggerFactory
			.getLogger(TinyFilterWrapper.class);

	@Override
	public void initTinyFilter() {
		super.initTinyFilter();
		String filterBeanNames = getInitParamMap().get(
				TinyFilterConfig.FILTER_BEAN_NAMES);
		if (filterBeanNames != null) {
			String[] beanNames = filterBeanNames.split(SPLIT_CHAR);
			logger.logMessage(LogLevel.INFO, "filter包装类开始实例化filter");
			for (String beanName : beanNames) {
				Filter filter = SpringUtil.getBean(beanName);
				if (filter != null) {
					logger.logMessage(LogLevel.INFO, "实例化filter：<{}>", beanName);
					try {
						filter.init(new TinyFilterConfig(getInitParamMap()));
					} catch (ServletException e) {
						logger.errorMessage("初始化filter:{}出错", e, beanName);
						throw new RuntimeException("初始化filter出错", e);
					}
					filters.add(filter);
				}
			}
			logger.logMessage(LogLevel.INFO, "filter包装类实例化filter结束");

		} else {
			throw new RuntimeException("找不到bean名称：" + filterBeanNames
					+ "对应的filter实例");
		}

	}

	@Override
	public void destoryTinyFilter() {
		super.destoryTinyFilter();
		for (Filter filter : filters) {
			filter.destroy();
		}
	}

	public void filterWrapper(WebContext context, TinyFilterHandler hander) {
		HttpServletRequest request = context.getRequest();
		HttpServletResponse response = context.getResponse();
		String servletPath = hander.getServletPath();
		if (isMatch(servletPath)) {
			TinyFilterChain filterChain = new TinyFilterChain(filters, hander);
			try {
				filterChain.doFilter(request, response);
			} catch (Exception e) {
				logger.errorMessage("过滤器:{}执行出错", e,
						filterChain.currentExcuteFilterName());
				throw new RuntimeException("过滤器执行出错", e);
			}
		}
	}

}
