/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.tinygroup.appconfig.AppConfigManager;
import org.tinygroup.application.Application;
import org.tinygroup.fileresolver.FileProcessor;
import org.tinygroup.fileresolver.FileResolver;
import org.tinygroup.fileresolver.impl.FileResolverImpl;
import org.tinygroup.fileresolver.impl.SpringBeansFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.filter.PathFilter;
import org.tinygroup.springutil.SpringUtil;
import org.tinygroup.weblayer.listener.ServletContextHolder;
import org.tinygroup.xmlparser.node.XmlNode;
import org.tinygroup.xmlparser.parser.XmlStringParser;

public class ApplicationStartupListener
implements ServletContextListener {
    private static Logger logger = LoggerFactory.getLogger(ApplicationStartupListener.class);
    private Application application;
    static String configString = null;

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        logger.logMessage(LogLevel.INFO, "WEB \u5e94\u7528\u505c\u6b62\u4e2d...");
        this.application.stop();
        SpringUtil.destory();
        logger.logMessage(LogLevel.INFO, "WEB \u5e94\u7528\u505c\u6b62\u5b8c\u6210\u3002");
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContextHolder.setServletContext(servletContextEvent.getServletContext());
        Enumeration enumeration = servletContextEvent.getServletContext().getAttributeNames();
        logger.logMessage(LogLevel.INFO, "WEB\u73af\u5883\u5c5e\u6027\u5f00\u59cb");
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            logger.logMessage(LogLevel.INFO, "{0}=[{1}]", new Object[]{key, servletContextEvent.getServletContext().getAttribute(key)});
        }
        logger.logMessage(LogLevel.INFO, "WEB \u5e94\u7528\u542f\u52a8\u4e2d...");
        this.loadSpringBeans();
        this.application = (Application)SpringUtil.getBean((String)"application");
        logger.logMessage(LogLevel.INFO, "WEB \u5e94\u7528\u4fe1\u606f\uff1a[{0}]", new Object[]{servletContextEvent.getServletContext().getServerInfo()});
        String webRootPath = servletContextEvent.getServletContext().getRealPath("/");
        if (webRootPath == null) {
            try {
                webRootPath = servletContextEvent.getServletContext().getResource("/").getFile();
            }
            catch (MalformedURLException e) {
                logger.errorMessage("\u83b7\u53d6WEBROOT\u5931\u8d25\uff01", (Throwable)e);
            }
        }
        logger.logMessage(LogLevel.INFO, "TINY_WEBROOT\uff1a[{0}]", new Object[]{webRootPath});
        this.application.getContext().put("TINY_WEBROOT", (Object)webRootPath);
        logger.logMessage(LogLevel.INFO, "\u5e94\u7528\u53c2\u6570<TINY_WEBROOT>=<{}>", new Object[]{webRootPath});
        logger.logMessage(LogLevel.INFO, "ServerContextName\uff1a[{0}]", new Object[]{servletContextEvent.getServletContext().getServletContextName()});
        logger.logMessage(LogLevel.INFO, "WEB\u73af\u5883\u5c5e\u6027\u7ed3\u675f");
        AppConfigManager appConfigManager = (AppConfigManager)SpringUtil.getBean((String)"appConfigManager");
        appConfigManager.loadConfig(ApplicationStartupListener.loadConfigContent());
        appConfigManager.distributeConfig();
        this.application.start();
        logger.logMessage(LogLevel.INFO, "WEB \u5e94\u7528\u542f\u52a8\u5b8c\u6210\u3002");
    }

    private void loadSpringBeans() {
        logger.logMessage(LogLevel.INFO, "\u52a0\u8f7dSpring Bean\u6587\u4ef6\u5f00\u59cb...");
        FileResolverImpl fileResolver = new FileResolverImpl();
        this.loadFileResolverConfig((FileResolver)fileResolver);
        fileResolver.addFileProcessor((FileProcessor)new SpringBeansFileProcessor());
        fileResolver.resolve();
        logger.logMessage(LogLevel.INFO, "\u52a0\u8f7dSpring Bean\u6587\u4ef6\u7ed3\u675f\u3002");
    }

    private void loadFileResolverConfig(FileResolver fileResolver) {
        XmlStringParser parser = new XmlStringParser();
        XmlNode root = (XmlNode)parser.parse(ApplicationStartupListener.loadConfigContent()).getRoot();
        PathFilter filter = new PathFilter((Node)root);
        String resolve = ((XmlNode)filter.findNode("/application/file-resolver-configuration")).getAttribute("resolve-classpath");
        if (resolve == null || resolve.length() == 0) {
            resolve = "true";
        }
        fileResolver.setClassPathResolve(Boolean.parseBoolean(resolve));
        List skipList = filter.findNodeList("/application/file-resolver-configuration/skip-patterns/skip-pattern");
        for (XmlNode node : skipList) {
            fileResolver.addSkipPathPattern(node.getAttribute("pattern"));
        }
        List classPathList = filter.findNodeList("/application/file-resolver-configuration/class-paths/class-path");
        for (XmlNode classPath : classPathList) {
            fileResolver.addManualClassPath(classPath.getAttribute("path"));
        }
        for (XmlNode node : skipList) {
            fileResolver.addSkipPathPattern(node.getAttribute("pattern"));
        }
    }

    private static String loadConfigContent() {
        try {
            logger.logMessage(LogLevel.INFO, "\u914d\u7f6e\u6587\u4ef6<{0}>\u52a0\u8f7d\u5f00\u59cb...", new Object[]{"/application.xml"});
            InputStream inputStream = ApplicationStartupListener.class.getResourceAsStream("/application.xml");
            byte[] bytes = new byte[inputStream.available()];
            inputStream.read(bytes);
            inputStream.close();
            String content = new String(bytes, "UTF-8");
            logger.logMessage(LogLevel.INFO, "\u914d\u7f6e\u6587\u4ef6<{0}>\u52a0\u8f7d\u5b8c\u6210\u3002", new Object[]{"/application.xml"});
            XmlNode configurationXmlNode = (XmlNode)new XmlStringParser().parse(content).getRoot();
            PathFilter filter = new PathFilter((Node)configurationXmlNode);
            List propertyList = filter.findNodeList("/application/application-properties/property");
            for (XmlNode property : propertyList) {
                String name = property.getAttribute("name");
                String value = property.getAttribute("value");
                content = ApplicationStartupListener.replace(content, name, value);
            }
            return content;
        }
        catch (Exception e) {
            logger.errorMessage("\u914d\u7f6e\u6587\u4ef6<{0}>\u52a0\u8f7d\u65f6\u53d1\u751f\u9519\u8bef\u3002", (Throwable)e, new Object[]{"/application.xml"});
            throw new RuntimeException(e);
        }
    }

    private static String replace(String content, String name, String value) {
        Pattern pattern = Pattern.compile("[{]" + name + "[}]");
        Matcher matcher = pattern.matcher(content);
        StringBuffer buf = new StringBuffer();
        int curpos = 0;
        while (matcher.find()) {
            buf.append(content.substring(curpos, matcher.start()));
            curpos = matcher.end();
            buf.append(value);
        }
        buf.append(content.substring(curpos));
        return buf.toString();
    }

    static {
        configString = ApplicationStartupListener.loadConfigContent();
    }
}

