/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.weblayer.TinyFilterHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TinyFilterChain
implements FilterChain {
    private List<Filter> filters = new ArrayList<Filter>();
    private int size;
    private int currentPosition = 0;
    private static final Logger logger = LoggerFactory.getLogger(TinyFilterChain.class);
    private TinyFilterHandler hander;

    public TinyFilterChain(List<Filter> filters, TinyFilterHandler hander) {
        this.filters = filters;
        this.size = filters.size();
        this.hander = hander;
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        ++this.currentPosition;
        if (this.currentPosition <= this.size) {
            Filter nextFilter = this.filters.get(this.currentPosition - 1);
            logger.logMessage(LogLevel.DEBUG, "firing Filter:'{}'", new Object[]{nextFilter.getClass().getSimpleName()});
            nextFilter.doFilter(request, response, (FilterChain)this);
        } else {
            this.hander.tinyFilterProcessor();
        }
    }

    public String currentExcuteFilterName() {
        String filterName = null;
        Filter currentFilter = this.filters.get(this.currentPosition - 1);
        if (currentFilter != null) {
            filterName = currentFilter.getClass().getSimpleName();
        }
        return filterName;
    }
}

