/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.applicationprocessor.configmanager.TinyFiterConfigManager;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.order.processor.OrderProcessor;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.filter.NameFilter;
import org.tinygroup.springutil.SpringUtil;
import org.tinygroup.weblayer.FilterWrapper;
import org.tinygroup.weblayer.TinyFilter;
import org.tinygroup.weblayer.TinyFilterManager;
import org.tinygroup.weblayer.impl.TinyFilterWrapper;
import org.tinygroup.xmlparser.node.XmlNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TinyFilterManagerImpl
implements TinyFilterManager {
    private TinyFiterConfigManager configManager;
    private Map<TinyFilter, List<XmlNode>> processorXmlNodes = new HashMap<TinyFilter, List<XmlNode>>();
    private static Logger logger = LoggerFactory.getLogger(TinyFilterManagerImpl.class);
    private List<TinyFilter> tinyFilters = new ArrayList<TinyFilter>();
    private TinyFilterWrapper wrapper;

    @Override
    public List<TinyFilter> getTinyFiltersWithUrl(String url) {
        ArrayList<TinyFilter> filters = new ArrayList<TinyFilter>();
        for (TinyFilter tinyFilter : this.tinyFilters) {
            if (!tinyFilter.isMatch(url)) continue;
            filters.add(tinyFilter);
        }
        return filters;
    }

    @Override
    public void initTinyResources() {
        if (this.configManager != null) {
            List configs = this.configManager.getConfigs();
            XmlNode application = this.configManager.getApplicationConfig();
            if (application != null) {
                configs.add(application);
            }
            for (XmlNode config : configs) {
                this.nodeProcessor(config);
            }
            OrderProcessor orderProcessor = (OrderProcessor)SpringUtil.getBean((String)"orderProcessor");
            this.tinyFilters = orderProcessor.orderList("tiny-filter", this.tinyFilters);
        }
    }

    private void nodeProcessor(XmlNode xmlNode) {
        this.processXmlNode(xmlNode);
        this.initProcessor();
    }

    private void processXmlNode(XmlNode xmlNode) {
        NameFilter nameFilter = new NameFilter((Node)xmlNode);
        List nodes = nameFilter.findNodeList("tiny-filter");
        for (XmlNode node : nodes) {
            this.processSubNode(node);
        }
        NameFilter wrapperFilter = new NameFilter((Node)xmlNode);
        List wrapperNode = wrapperFilter.findNodeList("tiny-wrapper-filter");
        for (XmlNode node : wrapperNode) {
            this.wrapper = (TinyFilterWrapper)this.processSubNode(node);
        }
    }

    private TinyFilter createTinyFilter(XmlNode node) {
        String filterId = node.getAttribute("id");
        String filterClassName = node.getAttribute("class");
        logger.logMessage(LogLevel.INFO, "tiny-filter:{}\u5f00\u59cb\u88ab\u52a0\u8f7d", new Object[]{filterId});
        TinyFilter filter = null;
        try {
            filter = this.instanceFilter(filterClassName);
        }
        catch (Exception e) {
            logger.errorMessage("\u521b\u5efatiny-filter\u5904\u7406\u5668\uff1a{}\u51fa\u9519\uff0c\u7531\u4e8e\u5176\u7c7b\u540d\u79f0\uff1a{}\u4e0d\u80fd\u8fdb\u884c\u5b9e\u4f8b\u5316", (Throwable)e, new Object[]{filterId, filterClassName});
            throw new RuntimeException(e);
        }
        logger.logMessage(LogLevel.INFO, "tiny-filter:{}\u52a0\u8f7d\u7ed3\u675f", new Object[]{filterId});
        return filter;
    }

    private TinyFilter processSubNode(XmlNode node) {
        TinyFilter filter = this.createTinyFilter(node);
        List<Object> processorNodes = null;
        processorNodes = !this.processorXmlNodes.containsKey(filter) ? new ArrayList() : this.processorXmlNodes.get(filter);
        if (processorNodes != null) {
            processorNodes.add(node);
            this.processorXmlNodes.put(filter, processorNodes);
        }
        this.tinyFilters.add(filter);
        return filter;
    }

    private void initProcessor() {
        for (TinyFilter tinyFilter : this.processorXmlNodes.keySet()) {
            XmlNode xmlNode = this.createXmlNode(this.processorXmlNodes.get(tinyFilter));
            tinyFilter.setConfiguration(xmlNode);
            tinyFilter.initTinyFilter();
        }
    }

    private XmlNode createXmlNode(List<XmlNode> xmlNodes) {
        XmlNode newXmlNode = new XmlNode("tiny-filter");
        for (XmlNode xmlNode : xmlNodes) {
            List subNodes = xmlNode.getSubNodes();
            for (XmlNode node : subNodes) {
                newXmlNode.addNode((Node)node);
            }
        }
        return newXmlNode;
    }

    private TinyFilter instanceFilter(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        TinyFilter filter = (TinyFilter)SpringUtil.getBean((String)className);
        if (filter == null) {
            filter = (TinyFilter)Class.forName(className).newInstance();
        }
        return filter;
    }

    @Override
    public void destoryTinyResources() {
        for (TinyFilter tinyFilter : this.tinyFilters) {
            tinyFilter.destoryTinyFilter();
        }
        this.configManager = null;
        this.processorXmlNodes = null;
        this.tinyFilters = null;
    }

    @Override
    public void setConfigManager(TinyFiterConfigManager configManager) {
        this.configManager = configManager;
    }

    @Override
    public boolean existFilterWrapper() {
        return this.wrapper != null;
    }

    @Override
    public FilterWrapper getFilterWrapper() {
        return this.wrapper;
    }
}

