/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.listener;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.commons.tools.Enumerator;
import org.tinygroup.fileresolver.FullContextFileRepository;
import org.tinygroup.springutil.SpringUtil;
import org.tinygroup.vfs.FileObject;

public class TinyServletContext
implements ServletContext {
    private ServletContext orignalContext;
    private FullContextFileRepository fullContextFileRepository;
    private Map<String, String> parameters = CollectionUtil.createHashMap();

    public TinyServletContext(ServletContext servletContext) {
        Assert.assertNotNull((Object)servletContext, (String)"servletContext must not null", (Object[])new Object[0]);
        this.orignalContext = servletContext;
        this.fullContextFileRepository = (FullContextFileRepository)SpringUtil.getBean((String)"fullContextFileRepository");
    }

    public String getContextPath() {
        return this.orignalContext.getContextPath();
    }

    public ServletContext getContext(String uripath) {
        return this.orignalContext.getContext(uripath);
    }

    public int getMajorVersion() {
        return this.orignalContext.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.orignalContext.getMinorVersion();
    }

    public String getMimeType(String file) {
        return this.orignalContext.getMimeType(file);
    }

    public Set getResourcePaths(String path) {
        return this.orignalContext.getResourcePaths(path);
    }

    public URL getResource(String path) throws MalformedURLException {
        FileObject fileObject;
        if (this.fullContextFileRepository != null && (fileObject = this.fullContextFileRepository.getFileObject(path)) != null && fileObject.isExist()) {
            return fileObject.getURL();
        }
        return this.orignalContext.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        FileObject fileObject;
        if (this.fullContextFileRepository != null && (fileObject = this.fullContextFileRepository.getFileObject(path)) != null && fileObject.isExist()) {
            return fileObject.getInputStream();
        }
        return this.orignalContext.getResourceAsStream(path);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.orignalContext.getRequestDispatcher(path);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return this.orignalContext.getNamedDispatcher(name);
    }

    @Deprecated
    public Servlet getServlet(String name) throws ServletException {
        return this.orignalContext.getServlet(name);
    }

    @Deprecated
    public Enumeration getServlets() {
        return this.orignalContext.getServlets();
    }

    public Enumeration getServletNames() {
        return this.orignalContext.getServletNames();
    }

    public void log(String msg) {
        this.orignalContext.log(msg);
    }

    @Deprecated
    public void log(Exception exception, String msg) {
        this.orignalContext.log(exception, msg);
    }

    public void log(String message, Throwable throwable) {
        this.orignalContext.log(message, throwable);
    }

    public String getRealPath(String path) {
        return this.orignalContext.getRealPath(path);
    }

    public String getServerInfo() {
        return this.orignalContext.getServerInfo();
    }

    public String getInitParameter(String name) {
        String value = this.parameters.get(name);
        if (value == null) {
            value = this.orignalContext.getInitParameter(name);
        }
        return value;
    }

    public Enumeration getInitParameterNames() {
        Enumeration enumeration = this.orignalContext.getInitParameterNames();
        Set<String> parameterSet = this.parameters.keySet();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            parameterSet.add(name);
        }
        return new Enumerator(parameterSet);
    }

    public Object getAttribute(String name) {
        return this.orignalContext.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.orignalContext.getAttributeNames();
    }

    public void setAttribute(String name, Object object) {
        this.orignalContext.setAttribute(name, object);
    }

    public void removeAttribute(String name) {
        this.orignalContext.removeAttribute(name);
    }

    public String getServletContextName() {
        return this.orignalContext.getServletContextName();
    }

    public void setInitParameter(String name, String value) {
        this.parameters.put(name, value);
    }
}

