/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.mvc;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import org.tinygroup.commons.beanutil.BeanUtil;
import org.tinygroup.commons.tools.ReflectionUtils;
import org.tinygroup.commons.tools.ValueUtil;
import org.tinygroup.context.Context;
import org.tinygroup.context2object.impl.ClassNameObjectGenerator;
import org.tinygroup.springutil.SpringUtil;
import org.tinygroup.weblayer.WebContext;
import org.tinygroup.weblayer.fc.Forward;
import org.tinygroup.weblayer.mvc.MappingClassModel;
import org.tinygroup.weblayer.mvc.MappingMethodModel;
import org.tinygroup.weblayer.mvc.WebContextAware;
import org.tinygroup.weblayer.mvc.annotation.View;

public class HandlerExecutionChain {
    private MappingClassModel model;
    private MappingMethodModel methodModel;
    private WebContext context;

    public HandlerExecutionChain(MappingClassModel model, MappingMethodModel methodModel) {
        this.model = model;
        this.methodModel = methodModel;
    }

    public MappingClassModel getModel() {
        return this.model;
    }

    public void setModel(MappingClassModel model) {
        this.model = model;
    }

    public MappingMethodModel getMethodModel() {
        return this.methodModel;
    }

    public void setMethodModel(MappingMethodModel methodModel) {
        this.methodModel = methodModel;
    }

    public WebContext getContext() {
        return this.context;
    }

    public void setContext(WebContext context) {
        this.context = context;
    }

    public void execute() {
        Method method = this.methodModel.getMapMethod();
        Class<?>[] paramTypes = method.getParameterTypes();
        Object[] args = new Object[paramTypes.length];
        String[] parameterNames = BeanUtil.getMethodParameterName(method.getDeclaringClass(), (Method)method);
        for (int i = 0; i < paramTypes.length; ++i) {
            args[i] = this.context.get(parameterNames[i]);
            Class<?> type = paramTypes[i];
            if (args[i] == null) {
                if (type.equals(WebContext.class)) {
                    args[i] = this.context;
                } else {
                    ClassNameObjectGenerator generator = (ClassNameObjectGenerator)SpringUtil.getBean((String)"classNameObjectGenerator");
                    if (Collection.class.isAssignableFrom(type)) {
                        ParameterizedType pt = (ParameterizedType)method.getGenericParameterTypes()[i];
                        Type[] actualTypeArguments = pt.getActualTypeArguments();
                        args[i] = generator.getObjectCollection(null, type.getName(), this.getClassName(actualTypeArguments[0].toString()), (Context)this.context);
                    } else {
                        args[i] = generator.getObject(null, null, type.getName(), (Context)this.context);
                    }
                }
            } else {
                args[i] = ValueUtil.getValue((String)args[i].toString(), (String)type.getName());
            }
            this.context.put(parameterNames[i], args[i]);
        }
        try {
            Object object = this.getInstance(this.model.getMapClass());
            if (object instanceof WebContextAware) {
                ((WebContextAware)object).setContext(this.context);
            }
            ReflectionUtils.invokeMethod((Method)method, (Object)object, (Object[])args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        View view = this.methodModel.getView();
        if (view != null) {
            String pathInfo = view.value();
            Forward forward = new Forward();
            forward.setPath(pathInfo);
            forward.execute(this.context);
        }
    }

    private Object getInstance(Class mapClass) throws Exception {
        Object object;
        block2: {
            object = null;
            try {
                object = SpringUtil.getBean((Class)mapClass);
            }
            catch (Exception e) {
                if (object != null) break block2;
                object = this.model.getMapClass().newInstance();
            }
        }
        return object;
    }

    private String getClassName(String rawType) {
        if (rawType == null || "".equals(rawType)) {
            throw new RuntimeException("\u88ab\u89e3\u6790\u7684\u5b57\u7b26\u4e32\u4e3a\u7a7a");
        }
        if (rawType.startsWith("interface ")) {
            return rawType.substring("interface ".length());
        }
        if (rawType.startsWith("class ")) {
            return rawType.substring("class ".length());
        }
        return rawType;
    }
}

