/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.tinyprocessor;

import org.tinygroup.context.Context;
import org.tinygroup.flow.FlowExecutor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.springutil.SpringUtil;
import org.tinygroup.weblayer.AbstractTinyProcessor;
import org.tinygroup.weblayer.WebContext;

public class PageFlowTinyProcessor
extends AbstractTinyProcessor {
    private Logger logger = LoggerFactory.getLogger(PageFlowTinyProcessor.class);
    private static final String NODE_ID = "tiny_flow_id";

    public void reallyProcess(String urlString, WebContext context) {
        this.logger.logMessage(LogLevel.INFO, "{}\u5f00\u59cb\u5904\u7406", new Object[]{urlString});
        String serviceId = this.getRequestId(urlString);
        FlowExecutor executor = (FlowExecutor)SpringUtil.getBean((String)"pageFlowExecutor");
        String nodeId = (String)context.get(NODE_ID);
        if (nodeId == null || "".equals(nodeId)) {
            executor.execute(serviceId, (Context)context);
        } else {
            executor.execute(serviceId, nodeId, (Context)context);
        }
        this.logger.logMessage(LogLevel.INFO, "{}\u5904\u7406\u7ed3\u675f", new Object[]{urlString});
    }

    public String getRequestId(String urlString) {
        int lastDot = urlString.lastIndexOf(".");
        int lastSlash = urlString.lastIndexOf("/");
        return urlString.substring(lastSlash + 1, lastDot);
    }
}

