/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.tinyprocessor;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletResponse;
import org.tinygroup.appconfig.AppConfigManager;
import org.tinygroup.context.Context;
import org.tinygroup.fileresolver.FullContextFileRepository;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.springutil.SpringUtil;
import org.tinygroup.velocity.VelocityHelper;
import org.tinygroup.velocity.config.VelocityContextConfig;
import org.tinygroup.velocity.impl.VelocityHelperImpl;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.weblayer.AbstractTinyProcessor;
import org.tinygroup.weblayer.WebContext;
import org.tinygroup.xmlparser.node.XmlNode;
import org.tinygroup.xstream.XStreamFactory;

public class VelocityLayoutViewTinyProcessor
extends AbstractTinyProcessor {
    private static final Logger logger = LoggerFactory.getLogger(VelocityLayoutViewTinyProcessor.class);
    private static final String PAGELET_EXT_FILE_NAME = ".pagelet";
    private static final String PAGE_EXT_FILE_NAME = ".page";
    private String templeteWithLayout = ".page";
    private String template = ".pagelet";
    private VelocityHelper velocityHelper;
    private FullContextFileRepository fullContextFileRepository;
    private static final String VELOCITY_CONFIGS = "velocity-context-config";

    public void init() {
        super.init();
        this.fullContextFileRepository = (FullContextFileRepository)SpringUtil.getBean((String)"fullContextFileRepository");
        VelocityHelperImpl velocityHelperImpl = (VelocityHelperImpl)SpringUtil.getBean((String)"velocityHelper");
        this.velocityHelper = velocityHelperImpl;
        this.templeteWithLayout = this.getInitParamMap().get("templeteWithLayoutExtFileName");
        this.template = this.getInitParamMap().get("templateExtFileName");
        if (this.templeteWithLayout == null || this.templeteWithLayout.length() == 0) {
            this.templeteWithLayout = PAGE_EXT_FILE_NAME;
        }
        if (this.template == null || this.template.length() == 0) {
            this.template = PAGELET_EXT_FILE_NAME;
        }
        this.initVelocityConfig();
    }

    private void initVelocityConfig() {
        AppConfigManager configManager = (AppConfigManager)SpringUtil.getBean((String)"appConfigManager");
        XmlNode root = configManager.getConfiguration();
        XmlNode velocityConfig = (XmlNode)root.getSubNode(VELOCITY_CONFIGS);
        XStream stream = XStreamFactory.getXStream((String)"velocity");
        if (velocityConfig != null) {
            VelocityContextConfig contextConfig = (VelocityContextConfig)stream.fromXML(velocityConfig.toString());
            this.velocityHelper.setVelocityContextConfig(contextConfig);
        }
    }

    public void reallyProcess(String servletPath, WebContext context) {
        HttpServletResponse response = context.getResponse();
        try {
            FileObject fileObject;
            long startTime = System.currentTimeMillis();
            boolean isPagelet = false;
            if (servletPath.endsWith(PAGELET_EXT_FILE_NAME)) {
                isPagelet = true;
                servletPath = servletPath.substring(0, servletPath.length() - PAGELET_EXT_FILE_NAME.length()) + PAGE_EXT_FILE_NAME;
            }
            if ((fileObject = this.fullContextFileRepository.getFileObjectDetectLocale(servletPath)) != null) {
                context.put("uiengine", SpringUtil.getBean((String)"uiComponentManager"));
                if (isPagelet) {
                    this.velocityHelper.processTempleate((Context)context, (Writer)response.getWriter(), servletPath);
                } else {
                    this.velocityHelper.processTempleateWithLayout((Context)context, (Writer)response.getWriter(), servletPath);
                }
                long endTime = System.currentTimeMillis();
                logger.logMessage(LogLevel.DEBUG, "\u8def\u5f84<{}>\u5904\u7406\u65f6\u95f4\uff1a{}ms", new Object[]{servletPath, endTime - startTime});
                return;
            }
            logger.logMessage(LogLevel.ERROR, "\u8def\u5f84<{}>\u5bf9\u5e94\u7684\u8d44\u6e90\u4e0d\u80fd\u88ab\u627e\u5230\u3002", new Object[]{servletPath});
        }
        catch (Exception e) {
            logger.errorMessage(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            response.sendError(404);
        }
        catch (IOException e) {
            logger.errorMessage("\u5199\u5165\u54cd\u5e94\u4fe1\u606f\u51fa\u9519", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

