/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.parser.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.weblayer.webcontext.parser.impl.HTMLInputFilter;

final class FilterRunner {
    private final HTMLInputFilter filter;
    private final Map vTagCounts = new HashMap();
    private static final Pattern escapeCommentsPattern = Pattern.compile("<!--(.*?)-->", 32);
    private static final Pattern checkTagsPattern = Pattern.compile("<(.*?)>", 32);
    private static final Pattern processTagPatternEnding = Pattern.compile("^/([a-z0-9]+)", 34);
    private static final Pattern processTagPatternStarting = Pattern.compile("^([a-z0-9]+)(.*?)(/?)$", 34);
    private static final Pattern processTagPatternComment = Pattern.compile("^!--(.*)--$", 34);

    public FilterRunner(HTMLInputFilter filter) {
        this.filter = filter;
    }

    public String filter(String input, boolean isHtml) {
        boolean debugEnabled = HTMLInputFilter.log.isDebugEnabled();
        String s = input;
        if (debugEnabled) {
            HTMLInputFilter.log.debug("************************************************");
            if (isHtml) {
                HTMLInputFilter.log.debug("         HTML INPUT: " + input);
            } else {
                HTMLInputFilter.log.debug("     ORDINARY INPUT: " + input);
            }
        }
        if (isHtml) {
            s = this.escapeComments(s);
            if (debugEnabled) {
                HTMLInputFilter.log.debug("     escapeComments: " + s);
            }
        }
        if (isHtml) {
            s = this.balanceHTML(s);
            if (debugEnabled) {
                HTMLInputFilter.log.debug("        balanceHTML: " + s);
            }
        }
        s = this.checkTags(s, isHtml);
        if (debugEnabled) {
            HTMLInputFilter.log.debug("          checkTags: " + s);
        }
        if (isHtml) {
            s = this.processRemoveBlanks(s);
            if (debugEnabled) {
                HTMLInputFilter.log.debug("processRemoveBlanks: " + s);
            }
        }
        if (isHtml) {
            s = this.validateEntities(s);
            if (debugEnabled) {
                HTMLInputFilter.log.debug("    validateEntites: " + s);
            }
        }
        if (debugEnabled) {
            HTMLInputFilter.log.debug("************************************************\n\n");
        }
        return s;
    }

    protected String escapeComments(String s) {
        Matcher m = escapeCommentsPattern.matcher(s);
        StringBuffer buf = new StringBuffer();
        if (m.find()) {
            String match = m.group(1);
            this.appendReplacement(m, buf, "<!--" + HTMLInputFilter.htmlSpecialChars(match) + "-->");
        }
        m.appendTail(buf);
        return buf.toString();
    }

    protected String balanceHTML(String s) {
        s = this.regexReplace("^>", "", s);
        s = this.regexReplace("<([^>]*?)(?=<|$)", "<$1>", s);
        s = this.regexReplace("(^|>)([^<]*?)(?=>)", "$1<$2", s);
        return s;
    }

    protected String checkTags(String s, boolean isHtml) {
        Matcher m = checkTagsPattern.matcher(s);
        StringBuffer buf = new StringBuffer();
        while (m.find()) {
            String replaceStr = m.group(1);
            replaceStr = this.processTag(replaceStr, isHtml);
            this.appendReplacement(m, buf, replaceStr);
        }
        m.appendTail(buf);
        s = buf.toString();
        if (isHtml) {
            for (String key : this.vTagCounts.keySet()) {
                for (int ii = 0; ii < (Integer)this.vTagCounts.get(key); ++ii) {
                    s = s + "</" + key + ">";
                }
            }
        }
        return s;
    }

    protected String processTag(String s, boolean isHtml) {
        Matcher m = processTagPatternEnding.matcher(s);
        if (m.find()) {
            String name = m.group(1).toLowerCase();
            if ((!isHtml || this.filter.vAllowed.containsKey(name)) && !this.filter.vSelfClosingTags.contains(name) && this.vTagCounts.containsKey(name)) {
                this.vTagCounts.put(name, new Integer((Integer)this.vTagCounts.get(name) - 1));
                return "</" + name + ">";
            }
            return "";
        }
        m = processTagPatternStarting.matcher(s);
        if (m.find()) {
            String name = m.group(1).toLowerCase();
            String body = m.group(2);
            String ending = m.group(3);
            if (this.filter.vDeniedTags.contains(name)) {
                return "";
            }
            if (this.filter.vAllowed.containsKey(name)) {
                String params = "";
                Pattern p2 = Pattern.compile("([a-z0-9]+)=([\"'])(.*?)\\2", 34);
                Pattern p3 = Pattern.compile("([a-z0-9]+)(=)([^\"\\s']+)", 34);
                Matcher m2 = p2.matcher(body);
                Matcher m3 = p3.matcher(body);
                ArrayList<String> paramNames = new ArrayList<String>();
                ArrayList<String> paramValues = new ArrayList<String>();
                while (m2.find()) {
                    paramNames.add(m2.group(1));
                    paramValues.add(m2.group(3));
                }
                while (m3.find()) {
                    paramNames.add(m3.group(1));
                    paramValues.add(m3.group(3));
                }
                for (int ii = 0; ii < paramNames.size(); ++ii) {
                    String paramName = ((String)paramNames.get(ii)).toLowerCase();
                    String paramValue = (String)paramValues.get(ii);
                    if (!((Set)this.filter.vAllowed.get(name)).contains(paramName)) continue;
                    if (this.filter.vProtocolAtts.contains(paramName)) {
                        paramValue = this.processParamProtocol(paramValue);
                    }
                    params = params + " " + paramName + "=\"" + paramValue + "\"";
                }
                if (this.filter.vSelfClosingTags.contains(name)) {
                    ending = " /";
                }
                if (this.filter.vNeedClosingTags.contains(name)) {
                    ending = "";
                }
                if (ending == null || ending.length() < 1) {
                    if (this.vTagCounts.containsKey(name)) {
                        this.vTagCounts.put(name, new Integer((Integer)this.vTagCounts.get(name) + 1));
                    } else {
                        this.vTagCounts.put(name, new Integer(1));
                    }
                } else {
                    ending = " /";
                }
                return "<" + name + params + ending + ">";
            }
            if (isHtml) {
                return "";
            }
            if (this.vTagCounts.containsKey(name)) {
                this.vTagCounts.put(name, new Integer((Integer)this.vTagCounts.get(name) + 1));
            } else {
                this.vTagCounts.put(name, new Integer(1));
            }
            if (isHtml && StringUtil.isEmpty((String)s)) {
                return "";
            }
            return "<" + s + ">";
        }
        m = processTagPatternComment.matcher(s);
        if (m.find()) {
            String comment = m.group();
            return "<" + comment + ">";
        }
        if (isHtml && StringUtil.isEmpty((String)s)) {
            return "";
        }
        return "<" + s + ">";
    }

    protected String processParamProtocol(String s) {
        String protocol;
        s = this.decodeEntities(s);
        Pattern p = Pattern.compile("^([^:]+):", 34);
        Matcher m = p.matcher(s);
        if (m.find() && !this.filter.vAllowedProtocols.contains(protocol = m.group(1)) && (s = "#" + s.substring(protocol.length() + 1, s.length())).startsWith("#//")) {
            s = "#" + s.substring(3, s.length());
        }
        return s;
    }

    protected String decodeEntities(String s) {
        int decimal;
        String match;
        StringBuffer buf = new StringBuffer();
        Pattern p = Pattern.compile("&#(\\d+);?");
        Matcher m = p.matcher(s);
        while (m.find()) {
            match = m.group(1);
            decimal = Integer.decode(match);
            this.appendReplacement(m, buf, HTMLInputFilter.chr(decimal));
        }
        m.appendTail(buf);
        s = buf.toString();
        buf = new StringBuffer();
        p = Pattern.compile("&#x([0-9a-f]+);?");
        m = p.matcher(s);
        while (m.find()) {
            match = m.group(1);
            decimal = Integer.decode(match);
            this.appendReplacement(m, buf, HTMLInputFilter.chr(decimal));
        }
        m.appendTail(buf);
        s = buf.toString();
        buf = new StringBuffer();
        p = Pattern.compile("%([0-9a-f]{2});?");
        m = p.matcher(s);
        while (m.find()) {
            match = m.group(1);
            decimal = Integer.decode(match);
            this.appendReplacement(m, buf, HTMLInputFilter.chr(decimal));
        }
        m.appendTail(buf);
        s = buf.toString();
        s = this.validateEntities(s);
        return s;
    }

    protected String processRemoveBlanks(String s) {
        for (String tag : this.filter.vRemoveBlanks) {
            s = this.regexReplace("<" + tag + "(\\s[^>]*)?></" + tag + ">", "", s);
            s = this.regexReplace("<" + tag + "(\\s[^>]*)?/>", "", s);
        }
        return s;
    }

    protected String validateEntities(String s) {
        String two;
        String one;
        Pattern p = Pattern.compile("&([^&;]*)(?=(;|&|$))");
        Matcher m = p.matcher(s);
        StringBuffer buf = new StringBuffer();
        if (m.find()) {
            one = m.group(1);
            two = m.group(2);
            this.appendReplacement(m, buf, this.checkEntity(one, two));
        }
        m.appendTail(buf);
        s = buf.toString();
        p = Pattern.compile("(>|^)([^<]+?)(<|$)", 32);
        m = p.matcher(s);
        buf = new StringBuffer();
        if (m.find()) {
            one = m.group(1);
            two = m.group(2);
            String three = m.group(3);
            this.appendReplacement(m, buf, one + two.replaceAll("\"", "&quot;") + three);
        }
        m.appendTail(buf);
        return s;
    }

    protected String checkEntity(String preamble, String term) {
        if (!term.equals(";")) {
            return "&amp;" + preamble;
        }
        if (this.isValidEntity(preamble)) {
            return "&" + preamble;
        }
        return "&amp;" + preamble;
    }

    protected boolean isValidEntity(String entity) {
        return this.filter.vAllowedEntities.contains(entity);
    }

    protected String regexReplace(String regex_pattern, String replacement, String s) {
        Pattern p = Pattern.compile(regex_pattern);
        Matcher m = p.matcher(s);
        return m.replaceAll(replacement);
    }

    private Matcher appendReplacement(Matcher matcher, StringBuffer buf, String replacement) {
        return matcher.appendReplacement(buf, this.quoteReplacement(replacement));
    }

    private String quoteReplacement(String s) {
        if (s.indexOf(92) == -1 && s.indexOf(36) == -1) {
            return s;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                sb.append('\\');
                sb.append('\\');
                continue;
            }
            if (c == '$') {
                sb.append('\\');
                sb.append('$');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

