/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.parser.impl;

import java.io.File;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.tinygroup.commons.tools.HumanReadableSize;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.support.BeanSupport;
import org.tinygroup.weblayer.webcontext.parser.exception.UploadException;
import org.tinygroup.weblayer.webcontext.parser.exception.UploadSizeLimitExceededException;
import org.tinygroup.weblayer.webcontext.parser.impl.DiskFileItemFactory;
import org.tinygroup.weblayer.webcontext.parser.impl.ServletFileUpload;
import org.tinygroup.weblayer.webcontext.parser.upload.FileUploadReName;
import org.tinygroup.weblayer.webcontext.parser.upload.UploadParameters;
import org.tinygroup.weblayer.webcontext.parser.upload.UploadService;

public class UploadServiceImpl
extends BeanSupport
implements UploadService {
    private static Logger logger = LoggerFactory.getLogger(UploadServiceImpl.class);
    private final UploadParameters params = new UploadParameters();
    private ServletFileUpload fileUpload;
    private FileUploadReName rename;

    public FileUploadReName getRename() {
        return this.rename;
    }

    public void setRename(FileUploadReName rename) {
        this.rename = rename;
    }

    public File getRepository() {
        return this.params.getRepository();
    }

    public HumanReadableSize getSizeMax() {
        return this.params.getSizeMax();
    }

    public HumanReadableSize getFileSizeMax() {
        return this.params.getFileSizeMax();
    }

    public HumanReadableSize getSizeThreshold() {
        return this.params.getSizeThreshold();
    }

    public boolean isKeepFormFieldInMemory() {
        return this.params.isKeepFormFieldInMemory();
    }

    public boolean isSaveInFile() {
        return this.params.isSaveInFile();
    }

    public void setSizeMax(HumanReadableSize sizeMax) {
        this.params.setSizeMax(sizeMax);
    }

    public void setFileSizeMax(HumanReadableSize fileSizeMax) {
        this.params.setFileSizeMax(fileSizeMax);
    }

    public void setSizeThreshold(HumanReadableSize sizeThreshold) {
        this.params.setSizeThreshold(sizeThreshold);
    }

    public void setKeepFormFieldInMemory(boolean keepFormFieldInMemory) {
        this.params.setKeepFormFieldInMemory(keepFormFieldInMemory);
    }

    public void setRepository(File repository) {
        this.params.setRepository(repository);
    }

    public void setSaveInFile(boolean saveInFile) {
        this.params.setSaveInFile(saveInFile);
    }

    public String[] getFileNameKey() {
        return this.params.getFileNameKey();
    }

    public void setFileNameKey(String[] fileNameKey) {
        this.params.setFileNameKey(fileNameKey);
    }

    protected void init() {
        this.params.applyDefaultValues();
        logger.logMessage(LogLevel.INFO, "Upload Parameters: {}", new Object[]{this.params});
        this.fileUpload = this.getFileUpload(this.params, false);
    }

    public boolean isMultipartContent(HttpServletRequest request) {
        return org.apache.commons.fileupload.servlet.ServletFileUpload.isMultipartContent((HttpServletRequest)request);
    }

    public FileItem[] parseRequest(HttpServletRequest request) {
        return this.parseRequest(request, null);
    }

    public FileItem[] parseRequest(HttpServletRequest request, UploadParameters params) {
        List<?> fileItems;
        this.assertInitialized();
        ServletFileUpload fileUpload = params == null || params.equals(this.params) ? this.fileUpload : this.getFileUpload(params, true);
        try {
            fileItems = fileUpload.parseRequest(request);
        }
        catch (FileUploadBase.SizeLimitExceededException e) {
            throw new UploadSizeLimitExceededException(e);
        }
        catch (FileUploadBase.FileSizeLimitExceededException e) {
            throw new UploadSizeLimitExceededException(e);
        }
        catch (FileUploadException e) {
            throw new UploadException(e);
        }
        return fileItems.toArray(new FileItem[fileItems.size()]);
    }

    private ServletFileUpload getFileUpload(UploadParameters params, boolean applyDefaultValues) {
        if (applyDefaultValues) {
            params.applyDefaultValues();
            logger.logMessage(LogLevel.DEBUG, "Upload Parameters: {}", new Object[]{params});
        }
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setRename(this.rename);
        factory.setRepository(params.getRepository());
        factory.setSizeThreshold((int)params.getSizeThreshold().getValue());
        factory.setKeepFormFieldInMemory(params.isKeepFormFieldInMemory());
        factory.setSaveInFile(params.isSaveInFile());
        ServletFileUpload fileUpload = new ServletFileUpload((FileItemFactory)factory);
        fileUpload.setSizeMax(params.getSizeMax().getValue());
        fileUpload.setFileSizeMax(params.getFileSizeMax().getValue());
        fileUpload.setFileNameKey(params.getFileNameKey());
        return fileUpload;
    }
}

