/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.parser.impl;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.tinygroup.commons.tools.BasicConstant;
import org.tinygroup.commons.tools.FileUtil;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.support.BeanSupport;
import org.tinygroup.weblayer.AbstractTinyFilter;
import org.tinygroup.weblayer.webcontext.parser.upload.UploadedFileFilter;

public class UploadedFileExtensionWhitelist
extends BeanSupport
implements UploadedFileFilter {
    private static Logger logger = LoggerFactory.getLogger(AbstractTinyFilter.class);
    private String[] extensions;

    public void setAllowedExtensions(String[] extensions) {
        this.extensions = extensions;
    }

    public boolean isFiltering(HttpServletRequest request) {
        return true;
    }

    protected void init() throws Exception {
        if (this.extensions == null) {
            this.extensions = BasicConstant.EMPTY_STRING_ARRAY;
        }
        for (int i = 0; i < this.extensions.length; ++i) {
            this.extensions[i] = FileUtil.normalizeExtension((String)this.extensions[i]);
        }
    }

    public FileItem filter(String key, FileItem file) {
        if (file == null) {
            return null;
        }
        boolean allowed = false;
        String ext = FileUtil.getExtension((String)file.getName(), (String)"null", (boolean)true);
        if (ext != null) {
            for (String allowedExtension : this.extensions) {
                if (!allowedExtension.equals(ext)) continue;
                allowed = true;
                break;
            }
        }
        if (!allowed) {
            logger.logMessage(LogLevel.WARN, "Uploaded file type \"{}\" is denied: {}", new Object[]{ext, file.getName()});
            return null;
        }
        return file;
    }
}

