/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.session.encode;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.commons.codec.binary.Base64;
import org.tinygroup.commons.io.ByteArrayOutputStream;
import org.tinygroup.commons.tools.ArrayUtil;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.support.BeanSupport;
import org.tinygroup.weblayer.webcontext.session.SessionStore;
import org.tinygroup.weblayer.webcontext.session.encode.SessionEncoder;
import org.tinygroup.weblayer.webcontext.session.encrypter.Encrypter;
import org.tinygroup.weblayer.webcontext.session.exception.SessionEncoderException;
import org.tinygroup.weblayer.webcontext.session.serializer.Serializer;
import org.tinygroup.weblayer.webcontext.session.serializer.impl.JavaSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSerializationEncoder
extends BeanSupport
implements SessionEncoder {
    protected Serializer serializer;
    protected Encrypter encrypter;

    protected void init() throws Exception {
        if (this.serializer == null) {
            this.serializer = new JavaSerializer();
        }
    }

    @Override
    public String encode(Map<String, Object> attrs, SessionStore.StoreContext storeContext) throws SessionEncoderException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Deflater def = new Deflater(9, false);
        DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)baos, def);
        try {
            this.serializer.serialize(Assert.assertNotNull(attrs, (String)"objectToEncode is null", (Object[])new Object[0]), dos);
        }
        catch (Exception e) {
            throw new SessionEncoderException("Failed to encode session state", e);
        }
        finally {
            try {
                dos.close();
            }
            catch (IOException e) {}
            def.end();
        }
        byte[] plaintext = baos.toByteArray().toByteArray();
        byte[] cryptotext = this.encrypt(plaintext);
        try {
            String encodedValue = new String(Base64.encodeBase64((byte[])cryptotext, (boolean)false), "ISO-8859-1");
            return URLEncoder.encode(encodedValue, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new SessionEncoderException("Failed to encode session state", e);
        }
    }

    private byte[] encrypt(byte[] plaintext) throws SessionEncoderException {
        if (this.encrypter != null) {
            return this.encrypter.encrypt(plaintext);
        }
        return plaintext;
    }

    @Override
    public Map<String, Object> decode(String encodedValue, SessionStore.StoreContext storeContext) throws SessionEncoderException {
        byte[] cryptotext = null;
        try {
            encodedValue = URLDecoder.decode((String)Assert.assertNotNull((Object)encodedValue, (String)"encodedValue is null", (Object[])new Object[0]), "ISO-8859-1");
            cryptotext = Base64.decodeBase64((byte[])encodedValue.getBytes("ISO-8859-1"));
            if (ArrayUtil.isEmptyArray((Object)cryptotext)) {
                throw new SessionEncoderException("Session state is empty: " + encodedValue);
            }
        }
        catch (Exception e) {
            throw new SessionEncoderException("Failed to decode session state: ", e);
        }
        byte[] plaintext = this.decrypt(cryptotext);
        if (ArrayUtil.isEmptyArray((Object)plaintext)) {
            throw new SessionEncoderException("Decrypted session state is empty: " + encodedValue);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(plaintext);
        Inflater inf = new Inflater(false);
        InflaterInputStream iis = new InflaterInputStream(bais, inf);
        try {
            Map attrs;
            Map map = attrs = (Map)this.serializer.deserialize(iis);
            return map;
        }
        catch (Exception e) {
            throw new SessionEncoderException("Failed to parse session state", e);
        }
        finally {
            try {
                iis.close();
            }
            catch (IOException e) {}
            inf.end();
        }
    }

    private byte[] decrypt(byte[] cryptotext) throws SessionEncoderException {
        if (this.encrypter != null) {
            return this.encrypter.decrypt(cryptotext);
        }
        return cryptotext;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.serializer + ", " + (this.encrypter == null ? "no encrypter" : this.encrypter) + "]";
    }
}

