/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.session.store;

import javax.servlet.http.HttpServletResponse;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.commons.tools.ObjectUtil;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.commons.tools.ToStringBuilder;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.weblayer.webcontext.session.SessionConfig;
import org.tinygroup.weblayer.webcontext.session.store.CookieStore;
import org.tinygroup.weblayer.webcontext.util.CookieSupport;

public abstract class AbstractCookieStore
implements CookieStore {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private String storeName;
    private SessionConfig.CookieConfig idCookieConfig;
    private String name;
    private String domain;
    private String path;
    private Integer maxAge;
    private Boolean httpOnly;
    private Boolean secure;
    private Boolean survivesInInvalidating;

    public String getStoreName() {
        return this.storeName;
    }

    public SessionConfig.CookieConfig getIdCookieConfig() {
        return this.idCookieConfig;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public void setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isSurvivesInInvalidating() {
        return this.survivesInInvalidating;
    }

    public void setSurvivesInInvalidating(boolean survivesInInvalidating) {
        this.survivesInInvalidating = survivesInInvalidating;
    }

    public final void init(String storeName, SessionConfig sessionConfig) throws Exception {
        this.idCookieConfig = ((SessionConfig)Assert.assertNotNull((Object)sessionConfig, (String)"sessionConfig", (Object[])new Object[0])).getId().getCookie();
        this.storeName = storeName;
        this.name = StringUtil.defaultIfEmpty((String)this.domain, (String)this.idCookieConfig.getName());
        if (StringUtil.isEmpty((String)this.name)) {
            throw new IllegalArgumentException("missing cookie name for store: " + storeName);
        }
        this.domain = StringUtil.defaultIfEmpty((String)this.domain, (String)this.idCookieConfig.getDomain());
        this.path = StringUtil.defaultIfEmpty((String)this.path, (String)this.idCookieConfig.getPath());
        this.maxAge = (Integer)ObjectUtil.defaultIfNull((Object)this.maxAge, (Object)this.idCookieConfig.getMaxAge());
        this.httpOnly = (Boolean)ObjectUtil.defaultIfNull((Object)this.httpOnly, (Object)this.idCookieConfig.isHttpOnly());
        this.secure = (Boolean)ObjectUtil.defaultIfNull((Object)this.secure, (Object)this.idCookieConfig.isSecure());
        this.survivesInInvalidating = (Boolean)ObjectUtil.defaultIfNull((Object)this.survivesInInvalidating, (Object)SURVIVES_IN_INVALIDATING_DEFAULT);
        if (this.survivesInInvalidating.booleanValue() && this.maxAge <= 0) {
            throw new IllegalArgumentException("Cookie store which Survives In Invalidating must specify MaxAge of cookie");
        }
        this.init();
    }

    protected void init() throws Exception {
    }

    protected void writeCookie(HttpServletResponse response, String cookieName, String cookieValue) {
        CookieSupport cookie = new CookieSupport(cookieName, cookieValue);
        if (!StringUtil.isEmpty((String)this.domain)) {
            cookie.setDomain(this.domain);
        }
        if (!StringUtil.isEmpty((String)this.path)) {
            cookie.setPath(this.path);
        }
        if (this.maxAge > 0) {
            cookie.setMaxAge(this.maxAge);
        }
        cookie.setHttpOnly(this.httpOnly);
        cookie.setSecure(this.secure);
        this.log.logMessage(LogLevel.DEBUG, "{}", new Object[]{cookie});
        cookie.addCookie(response);
    }

    public final String toString() {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
        this.toString(mb);
        return new ToStringBuilder().append((Object)"CookieStore").append((Object)mb).toString();
    }

    protected void toString(ToStringBuilder.MapBuilder mb) {
        mb.append("name", (Object)this.name);
        mb.append("domain", (Object)this.domain);
        mb.append("path", (Object)this.path);
        mb.append("maxAge", (Object)String.format("%,d seconds", this.maxAge));
        mb.append("httpOnly", (Object)this.httpOnly);
        mb.append("secure", (Object)this.secure);
        mb.append("survivesInInvalidating", (Object)this.survivesInInvalidating);
    }
}

