/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.session.store.impl;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.tinygroup.cache.Cache;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.support.BeanSupport;
import org.tinygroup.weblayer.webcontext.session.SessionConfig;
import org.tinygroup.weblayer.webcontext.session.SessionStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheStore
extends BeanSupport
implements SessionStore {
    private Cache cache;

    public Cache getCache() {
        return this.cache;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    protected void init() {
        Assert.assertNotNull((Object)this.cache, (String)"cache must not null", (Object[])new Object[0]);
    }

    @Override
    public void init(String storeName, SessionConfig sessionConfig) throws Exception {
    }

    @Override
    public Iterable<String> getAttributeNames(String sessionID, SessionStore.StoreContext storeContext) {
        Set sessionData = this.cache.getGroupKeys(sessionID);
        if (sessionData == null) {
            return Collections.emptyList();
        }
        return sessionData;
    }

    @Override
    public Object loadAttribute(String attrName, String sessionID, SessionStore.StoreContext storeContext) {
        return this.cache.get(sessionID, attrName);
    }

    @Override
    public void invaldiate(String sessionID, SessionStore.StoreContext storeContext) {
        this.cache.cleanGroup(sessionID);
    }

    @Override
    public void commit(Map<String, Object> modifiedAttrs, String sessionID, SessionStore.StoreContext storeContext) {
        for (Map.Entry<String, Object> entry : modifiedAttrs.entrySet()) {
            String attrName = entry.getKey();
            Object attrValue = entry.getValue();
            if (attrValue == null) {
                this.cache.remove(attrName);
                continue;
            }
            this.cache.put(sessionID, attrName, attrValue);
        }
    }
}

