/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.apis.bighugethesaurus;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.tiogasolutions.apis.bighugethesaurus.Cache;
import org.tiogasolutions.apis.bighugethesaurus.CacheException;
import org.tiogasolutions.dev.common.IoUtils;
import org.tiogasolutions.dev.common.exceptions.ExceptionUtils;

public class ZipFileSystemCache
implements Cache {
    private final File cacheDir;

    public ZipFileSystemCache(File cacheDir) throws IOException {
        ExceptionUtils.assertNotNull((Object)cacheDir, (String)"cacheDir");
        ExceptionUtils.assertIsDirectory((File)cacheDir);
        this.cacheDir = cacheDir;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String get(String word) {
        try {
            File file = this.getZipFile(word);
            if (!file.exists()) {
                return null;
            }
            try (FileInputStream fis = new FileInputStream(file);){
                ZipInputStream zis = new ZipInputStream(fis);
                byte[] data = IoUtils.toBytes((ZipInputStream)zis);
                String string = new String(data);
                return string;
            }
        }
        catch (Throwable e) {
            throw new CacheException("Unexpected exception reading from the cache.", e);
        }
    }

    @Override
    public String put(String word, String json) {
        try {
            File file = this.getZipFile(word);
            try (FileOutputStream fos = new FileOutputStream(file);
                 ZipOutputStream out = new ZipOutputStream(fos);){
                ZipEntry entry = new ZipEntry(word + ".json");
                out.putNextEntry(entry);
                out.write(json.getBytes());
            }
            return json;
        }
        catch (Throwable e) {
            throw new CacheException("Unexpected exception writing to the cache.", e);
        }
    }

    public File getZipFile(String word) {
        String fileName = word + ".json.zip";
        return new File(this.cacheDir, fileName);
    }

    public void clear() throws IOException {
        try {
            for (File file : IoUtils.list((File)this.cacheDir)) {
                IoUtils.deleteFile((File)file);
            }
        }
        catch (Throwable e) {
            throw new CacheException("Unexpected exception clearing the cache.", e);
        }
    }
}

