/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.apis.bighugethesaurus;

import java.io.IOException;
import java.net.URI;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.tiogasolutions.apis.bighugethesaurus.Cache;
import org.tiogasolutions.apis.bighugethesaurus.Result;
import org.tiogasolutions.dev.common.StringUtils;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.dev.common.json.JsonTranslator;
import org.tiogasolutions.dev.common.net.HttpStatusCode;

public class BigHugeThesaurusApis {
    private final String apiKey;
    private final String version;
    private final JsonTranslator translator;
    private final Cache cache;
    private final String urlTemplate;
    Client client = ClientBuilder.newBuilder().build();

    public BigHugeThesaurusApis(JsonTranslator translator, Cache cache, String apiKey) {
        this("words.bighugelabs.com", translator, cache, "2", apiKey);
    }

    public BigHugeThesaurusApis(String apiEndPoint, JsonTranslator translator, Cache cache, String version, String apiKey) {
        this.cache = cache;
        this.apiKey = apiKey;
        this.version = version;
        this.translator = translator;
        this.urlTemplate = "http://" + apiEndPoint + "/api/%s/%s/%s/json";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result lookup(String word) throws IOException {
        String path = String.format(this.urlTemplate, this.version, this.apiKey, StringUtils.encodeUrl((Object)word));
        URI uri = URI.create(path);
        try {
            String json = this.cache.get(word);
            if (json != null) {
                if (!StringUtils.isBlank((Object)json)) return (Result)this.translator.fromJson(Result.class, json, new Class[0]);
                return null;
            }
            Response response = this.client.target(uri).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
            int status = response.getStatus();
            if (status == 200) {
                json = (String)response.readEntity(String.class);
                this.cache.put(word, json);
                return (Result)this.translator.fromJson(Result.class, json, new Class[0]);
            }
            if (status == 404) {
                System.out.printf("The word \"%s\" was not found.%n", word);
                return null;
            }
            String msg = String.format("%s: Unable to process request for \"%s\" at %s", status, word, uri);
            throw new ApiException(HttpStatusCode.findByCode((int)status), msg, new String[0]);
        }
        catch (ApiException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String msg = String.format("Unexpected exception processing \"%s\" at %s", word, uri);
            throw new IOException(msg, ex);
        }
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getVersion() {
        return this.version;
    }

    public JsonTranslator getTranslator() {
        return this.translator;
    }

    public Cache getCache() {
        return this.cache;
    }
}

