/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.apis.bighugethesaurus;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import org.tiogasolutions.apis.bighugethesaurus.WordType;

public class Result {
    private final WordType unknown;
    private final WordType noun;
    private final WordType verb;
    private final WordType adverb;
    private final WordType adjective;

    @JsonCreator
    public Result(@JsonProperty(value="unknown") WordType unknown, @JsonProperty(value="noun") WordType noun, @JsonProperty(value="verb") WordType verb, @JsonProperty(value="adverb") WordType adverb, @JsonProperty(value="adjective") WordType adjective) {
        this.unknown = unknown;
        this.noun = noun;
        this.verb = verb;
        this.adverb = adverb;
        this.adjective = adjective;
    }

    public WordType getUnknown() {
        return this.unknown;
    }

    public WordType getAdverb() {
        return this.adverb;
    }

    public WordType getVerb() {
        return this.verb;
    }

    public WordType getNoun() {
        return this.noun;
    }

    public WordType getAdjective() {
        return this.adjective;
    }

    public Set<String> getAllWords() {
        TreeSet<String> set = new TreeSet<String>();
        for (WordType wordType : Arrays.asList(this.noun, this.verb, this.adverb, this.adjective, this.unknown)) {
            if (wordType == null) continue;
            set.addAll(wordType.getAntonyms());
            set.addAll(wordType.getSynonyms());
            set.addAll(wordType.getSimilar());
            set.addAll(wordType.getRelated());
        }
        return set;
    }
}

