/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.apis.bighugethesaurus;

import java.io.File;
import java.io.IOException;
import org.tiogasolutions.apis.bighugethesaurus.Cache;
import org.tiogasolutions.apis.bighugethesaurus.CacheException;
import org.tiogasolutions.dev.common.IoUtils;
import org.tiogasolutions.dev.common.exceptions.ExceptionUtils;

public class FileSystemCache
implements Cache {
    private final File cacheDir;

    public FileSystemCache(File cacheDir) throws IOException {
        ExceptionUtils.assertNotNull((Object)cacheDir, (String)"cacheDir");
        ExceptionUtils.assertIsDirectory((File)cacheDir);
        this.cacheDir = cacheDir;
    }

    @Override
    public String get(String word) {
        try {
            File file = this.getJsonFile(word);
            return file.exists() ? IoUtils.toString((File)file) : null;
        }
        catch (Throwable e) {
            throw new CacheException("Unexpected exception reading from the cache.", e);
        }
    }

    @Override
    public String put(String word, String json) {
        try {
            File file = this.getJsonFile(word);
            IoUtils.write((File)file, (String)json);
            return json;
        }
        catch (Throwable e) {
            throw new CacheException("Unexpected exception writing to the cache.", e);
        }
    }

    public File getJsonFile(String word) {
        String fileName = word + ".json";
        return new File(this.cacheDir, fileName);
    }

    public void clear() throws IOException {
        try {
            for (File file : IoUtils.list((File)this.cacheDir)) {
                IoUtils.deleteFile((File)file);
            }
        }
        catch (Throwable e) {
            throw new CacheException("Unexpected exception clearing the cache.", e);
        }
    }
}

