/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.apis.bitly;

import java.io.IOException;
import java.net.URI;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.tiogasolutions.dev.common.StringUtils;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.dev.common.json.JsonTranslator;
import org.tiogasolutions.dev.jackson.TiogaJacksonTranslator;

public class BitlyApis {
    private final String accessToken;
    private final String version;
    private final String urlTemplate;
    private final JsonTranslator translator = new TiogaJacksonTranslator();
    private final Client client = ClientBuilder.newBuilder().build();

    public BitlyApis(String accessToken) {
        this("api-ssl.bitly.com", "3", accessToken);
    }

    public BitlyApis(String apiEndPoint, String version, String accessToken) {
        this.accessToken = accessToken;
        this.version = version;
        this.urlTemplate = "https://" + apiEndPoint + "/v%s/%s";
    }

    public String parseAndShorten(String content) {
        if (content == null) {
            return null;
        }
        content = this.parseAndShorten(content, "http://");
        return this.parseAndShorten(content, "https://");
    }

    protected String parseAndShorten(String content, String prefix) {
        if (content == null) {
            return null;
        }
        int pos = content.indexOf(prefix);
        return this.parseAndShorten(content, prefix, pos);
    }

    protected String parseAndShorten(String content, String prefix, int posA) {
        int fromIndex;
        char chr;
        int posB;
        if (posA < 0) {
            return content;
        }
        for (posB = posA + 1; posB < content.length() && !Character.isWhitespace(chr = content.charAt(posB)); ++posB) {
        }
        String left = content.substring(0, posA);
        String right = content.substring(posB);
        String longUrl = content.substring(posA, posB);
        try {
            String shortUrl = this.shortenUnencodedUrl(longUrl);
            content = left + shortUrl + right;
            fromIndex = left.length() + shortUrl.length();
        }
        catch (Exception e) {
            content = left + longUrl + right;
            fromIndex = left.length() + longUrl.length();
        }
        int pos = content.indexOf(prefix, fromIndex);
        return this.parseAndShorten(content, prefix, pos);
    }

    public String shortenUnencodedUrl(String longUrl) throws IOException {
        longUrl = StringUtils.encodeUrl((Object)longUrl);
        return this.shortenEncodedUrl(longUrl);
    }

    public String shortenEncodedUrl(String longUrl) throws IOException {
        String prettyUrl = StringUtils.decodeUrl((Object)longUrl);
        String path = String.format(this.urlTemplate, this.version, "shorten");
        URI uri = URI.create(path);
        try {
            Response response = this.client.target(uri).queryParam("format", new Object[]{"txt"}).queryParam("longUrl", new Object[]{longUrl}).queryParam("access_token", new Object[]{this.accessToken}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
            int status = response.getStatus();
            String text = ((String)response.readEntity(String.class)).trim();
            if (status == 200) {
                return text;
            }
            String msg = String.format("%s: Unable to process request to shortenEncoded %s (%s)", status, prettyUrl, text);
            throw ApiException.fromCode((int)status, (String)msg, (String[])new String[0]);
        }
        catch (ApiException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String msg = String.format("Unexpected exception shortening %s", prettyUrl);
            throw new IOException(msg, ex);
        }
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getVersion() {
        return this.version;
    }

    public JsonTranslator getTranslator() {
        return this.translator;
    }
}

