/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.apis.easypost;

import javax.ws.rs.core.Form;
import org.tiogasolutions.apis.easypost.carrier.PredefinedPackage;
import org.tiogasolutions.apis.easypost.pub.Address;
import org.tiogasolutions.apis.easypost.pub.Parcel;
import org.tiogasolutions.apis.easypost.pub.Shipment;
import org.tiogasolutions.apis.easypost.requests.BuyRateRequest;
import org.tiogasolutions.apis.easypost.requests.BuyRateResponse;
import org.tiogasolutions.apis.easypost.requests.CreateAddressRequest;
import org.tiogasolutions.apis.easypost.requests.CreateParcelRequest;
import org.tiogasolutions.apis.easypost.requests.CreateShipmentRequest;
import org.tiogasolutions.dev.common.json.JsonTranslator;
import org.tiogasolutions.dev.jackson.TiogaJacksonTranslator;
import org.tiogasolutions.lib.jaxrs.client.Authorization;
import org.tiogasolutions.lib.jaxrs.client.BasicAuthorization;
import org.tiogasolutions.lib.jaxrs.client.SimpleRestClient;

public class EasyPostClient {
    private final SimpleRestClient client;

    public EasyPostClient(String apiKey) {
        TiogaJacksonTranslator translator = new TiogaJacksonTranslator();
        this.client = new SimpleRestClient((JsonTranslator)translator, (Object)"https://api.easypost.com/v2", (Authorization)new BasicAuthorization(apiKey, ""));
    }

    public Address createBusinessAddress(String name, String company, String street1, String street2, String city, String state, String zip, String phone, String email) {
        return this.createAddress(name, company, street1, street2, city, state, zip, null, phone, email, false);
    }

    public Address createResidentialAddress(String name, String street1, String street2, String city, String state, String zip, String phone, String email) {
        return this.createAddress(name, null, street1, street2, city, state, zip, null, phone, email, true);
    }

    public Address createAddress(String name, String company, String street1, String street2, String city, String state, String zip, String country, String phone, String email, boolean residential) {
        CreateAddressRequest createAddressRequest = new CreateAddressRequest(name, company, street1, street2, city, state, zip, country, phone, email, residential);
        return this.createAddress(createAddressRequest);
    }

    public Address createAddress(CreateAddressRequest createAddressRequest) {
        Form form = createAddressRequest.toForm();
        return (Address)this.client.post(Address.class, "/addresses", (Object)form);
    }

    public Parcel createParcel(double weight, PredefinedPackage predefinedPackage) {
        CreateParcelRequest createParcelRequest = new CreateParcelRequest(weight, predefinedPackage);
        return this.createParcel(createParcelRequest);
    }

    public Parcel createParcel(double weight, double length, double width, double height) {
        CreateParcelRequest createParcelRequest = new CreateParcelRequest(weight, length, width, height);
        return this.createParcel(createParcelRequest);
    }

    public Parcel createParcel(CreateParcelRequest createParcelRequest) {
        Form form = createParcelRequest.toForm();
        return (Parcel)this.client.post(Parcel.class, "/parcels", (Object)form);
    }

    public Shipment createShipment(CreateParcelRequest newParcel, CreateAddressRequest toAddress, CreateAddressRequest fromAddress) {
        CreateShipmentRequest newShipment = new CreateShipmentRequest(newParcel, toAddress, fromAddress);
        return this.createShipment(newShipment);
    }

    public Shipment createShipmentFrom(Parcel parcel, Address toAddress, Address fromAddress) {
        CreateShipmentRequest newShipment = new CreateShipmentRequest(parcel, toAddress, fromAddress);
        return this.createShipment(newShipment);
    }

    public Shipment createShipment(CreateShipmentRequest newShipment) {
        Form form = newShipment.toForm();
        return (Shipment)this.client.post(Shipment.class, "/shipments", (Object)form);
    }

    public BuyRateResponse buyPostage(BuyRateRequest buyRateRequest) {
        Form form = buyRateRequest.toForm();
        String url = String.format("/shipments/%s/buy", buyRateRequest.getShipmentId());
        return (BuyRateResponse)this.client.post(BuyRateResponse.class, url, (Object)form);
    }
}

