/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.apis.easypost.requests;

import javax.ws.rs.core.Form;
import org.tiogasolutions.apis.easypost.pub.Address;
import org.tiogasolutions.apis.easypost.pub.Parcel;
import org.tiogasolutions.apis.easypost.requests.CreateAddressRequest;
import org.tiogasolutions.apis.easypost.requests.CreateParcelRequest;

public class CreateShipmentRequest {
    private final String toAddresssId;
    private final String fromAddressId;
    private final String parcelId;
    private final CreateAddressRequest toAddress;
    private final CreateAddressRequest fromAddress;
    private final CreateParcelRequest parcel;

    public CreateShipmentRequest(Parcel parcel, Address fromAddress, Address toAddress) {
        this.parcelId = parcel.getId();
        this.toAddresssId = toAddress.getId();
        this.fromAddressId = fromAddress.getId();
        this.parcel = null;
        this.fromAddress = null;
        this.toAddress = null;
    }

    public CreateShipmentRequest(CreateParcelRequest parcel, CreateAddressRequest fromAddress, CreateAddressRequest toAddresss) {
        this.parcel = parcel;
        this.fromAddress = fromAddress;
        this.toAddress = toAddresss;
        this.toAddresssId = null;
        this.fromAddressId = null;
        this.parcelId = null;
    }

    public CreateAddressRequest getToAddress() {
        return this.toAddress;
    }

    public CreateAddressRequest getFromAddress() {
        return this.fromAddress;
    }

    public CreateParcelRequest getParcel() {
        return this.parcel;
    }

    public Form toForm() {
        Form form = new Form();
        if (this.parcelId != null) {
            form.param("shipment[to_address][id]", this.toAddresssId);
            form.param("shipment[from_address][id]", this.fromAddressId);
            form.param("shipment[parcel][id]", this.parcelId);
        } else {
            form.param("shipment[to_address][name]", this.toAddress.getName());
            form.param("shipment[to_address][company]", this.toAddress.getCompany());
            form.param("shipment[to_address][street1]", this.toAddress.getStreet1());
            form.param("shipment[to_address][street2]", this.toAddress.getStreet2());
            form.param("shipment[to_address][city]", this.toAddress.getCity());
            form.param("shipment[to_address][state]", this.toAddress.getState());
            form.param("shipment[to_address][zip]", this.toAddress.getZip());
            form.param("shipment[to_address][country]", this.toAddress.getCountry());
            form.param("shipment[to_address][phone]", this.toAddress.getPhone());
            form.param("shipment[to_address][email]", this.toAddress.getEmail());
            form.param("shipment[to_address][residential]", String.valueOf(this.toAddress.isResidential()));
            form.param("shipment[from_address][name]", this.fromAddress.getName());
            form.param("shipment[from_address][company]", this.fromAddress.getCompany());
            form.param("shipment[from_address][street1]", this.fromAddress.getStreet1());
            form.param("shipment[from_address][street2]", this.fromAddress.getStreet2());
            form.param("shipment[from_address][city]", this.fromAddress.getCity());
            form.param("shipment[from_address][state]", this.fromAddress.getState());
            form.param("shipment[from_address][zip]", this.fromAddress.getZip());
            form.param("shipment[from_address][country]", this.fromAddress.getCountry());
            form.param("shipment[from_address][phone]", this.fromAddress.getPhone());
            form.param("shipment[from_address][email]", this.fromAddress.getEmail());
            form.param("shipment[from_address][residential]", String.valueOf(this.fromAddress.isResidential()));
            if (this.parcel.getPredefinedPackage() != null) {
                form.param("shipment[parcel][weight]", String.valueOf(this.parcel.getWeight()));
                form.param("shipment[parcel][predefined_package]", this.parcel.getPredefinedPackage());
            } else {
                form.param("shipment[parcel][weight]", String.valueOf(this.parcel.getWeight()));
                form.param("shipment[parcel][length]", String.valueOf(this.parcel.getLength()));
                form.param("shipment[parcel][width]", String.valueOf(this.parcel.getWidth()));
                form.param("shipment[parcel][height]", String.valueOf(this.parcel.getHeight()));
            }
        }
        return form;
    }
}

