/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.apis.easypost;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.ws.rs.core.Form;
import org.tiogasolutions.apis.easypost.carrier.EpPredefinedPackage;
import org.tiogasolutions.apis.easypost.pub.EpAddress;
import org.tiogasolutions.apis.easypost.pub.EpLabelFormat;
import org.tiogasolutions.apis.easypost.pub.EpParcel;
import org.tiogasolutions.apis.easypost.pub.EpShipment;
import org.tiogasolutions.apis.easypost.requests.EpCreateAddressRequest;
import org.tiogasolutions.apis.easypost.requests.EpCreateParcelRequest;
import org.tiogasolutions.apis.easypost.requests.EpCreateShipmentRequest;
import org.tiogasolutions.apis.easypost.requests.EpPurchaseShipmentRequest;
import org.tiogasolutions.apis.easypost.requests.EpPurchaseShippingResponse;
import org.tiogasolutions.dev.common.json.JsonTranslator;
import org.tiogasolutions.dev.jackson.TiogaJacksonObjectMapper;
import org.tiogasolutions.dev.jackson.TiogaJacksonTranslator;
import org.tiogasolutions.lib.jaxrs.client.Authorization;
import org.tiogasolutions.lib.jaxrs.client.BasicAuthorization;
import org.tiogasolutions.lib.jaxrs.client.SimpleRestClient;

public class EasyPostClient {
    private final SimpleRestClient client;

    public EasyPostClient(String apiKey, JsonTranslator translator) {
        this.client = new SimpleRestClient(translator, (Object)"https://api.easypost.com/v2", (Authorization)new BasicAuthorization(apiKey, ""));
    }

    public EasyPostClient(String apiKey) {
        TiogaJacksonObjectMapper objectMapper = new TiogaJacksonObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        TiogaJacksonTranslator translator = new TiogaJacksonTranslator((ObjectMapper)objectMapper);
        this.client = new SimpleRestClient((JsonTranslator)translator, (Object)"https://api.easypost.com/v2", (Authorization)new BasicAuthorization(apiKey, ""));
    }

    public EpAddress createBusinessAddress(String name, String company, String street1, String street2, String city, String state, String zip, String phone, String email) {
        return this.createAddress(name, company, street1, street2, city, state, zip, null, phone, email, false);
    }

    public EpAddress createResidentialAddress(String name, String street1, String street2, String city, String state, String zip, String phone, String email) {
        return this.createAddress(name, null, street1, street2, city, state, zip, null, phone, email, true);
    }

    public EpAddress createAddress(String name, String company, String street1, String street2, String city, String state, String zip, String country, String phone, String email, boolean residential) {
        EpCreateAddressRequest createAddressRequest = new EpCreateAddressRequest(name, company, street1, street2, city, state, zip, country, phone, email, residential);
        return this.createAddress(createAddressRequest);
    }

    public EpAddress createAddress(EpCreateAddressRequest createAddressRequest) {
        Form form = createAddressRequest.toForm();
        return (EpAddress)this.client.post(EpAddress.class, "/addresses", (Object)form);
    }

    public EpParcel createParcel(double weight, EpPredefinedPackage predefinedPackage) {
        EpCreateParcelRequest createParcelRequest = new EpCreateParcelRequest(weight, predefinedPackage);
        return this.createParcel(createParcelRequest);
    }

    public EpParcel createParcel(double weight, double length, double width, double height) {
        EpCreateParcelRequest createParcelRequest = new EpCreateParcelRequest(weight, length, width, height);
        return this.createParcel(createParcelRequest);
    }

    public EpParcel createParcel(EpCreateParcelRequest createParcelRequest) {
        Form form = createParcelRequest.toForm();
        return (EpParcel)this.client.post(EpParcel.class, "/parcels", (Object)form);
    }

    public EpShipment createShipment(EpCreateParcelRequest newParcel, EpCreateAddressRequest fromAddress, EpCreateAddressRequest toAddress, EpLabelFormat labelFormat) {
        EpCreateShipmentRequest newShipment = new EpCreateShipmentRequest(newParcel, fromAddress, toAddress, labelFormat);
        return this.createShipment(newShipment);
    }

    public EpShipment createShipmentFrom(EpParcel parcel, EpAddress fromAddress, EpAddress toAddress, EpLabelFormat labelFormat) {
        EpCreateShipmentRequest newShipment = new EpCreateShipmentRequest(parcel, fromAddress, toAddress, labelFormat);
        return this.createShipment(newShipment);
    }

    public EpShipment createShipment(EpCreateShipmentRequest newShipment) {
        Form form = newShipment.toForm();
        return (EpShipment)this.client.post(EpShipment.class, "/shipments", (Object)form);
    }

    public EpPurchaseShippingResponse purchaseShipment(EpPurchaseShipmentRequest purchaseRequest) {
        Form form = purchaseRequest.toForm();
        String url = String.format("/shipments/%s/buy", purchaseRequest.getShipmentId());
        return (EpPurchaseShippingResponse)this.client.post(EpPurchaseShippingResponse.class, url, (Object)form);
    }

    public EpShipment getShipment(EpShipment shipment) {
        return this.getShipment(shipment.getId());
    }

    public EpShipment getShipment(String id) {
        String url = String.format("/shipments/%s", id);
        return (EpShipment)this.client.get(EpShipment.class, url, new String[0]);
    }

    public EpParcel getParcel(EpParcel parcel) {
        return this.getParcel(parcel.getId());
    }

    public EpParcel getParcel(String id) {
        String url = String.format("/parcels/%s", id);
        return (EpParcel)this.client.get(EpParcel.class, url, new String[0]);
    }

    public EpAddress getAddress(EpAddress address) {
        return this.getAddress(address.getId());
    }

    public EpAddress getAddress(String id) {
        String url = String.format("/addresses/%s", id);
        return (EpAddress)this.client.get(EpAddress.class, url, new String[0]);
    }
}

