/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.apis.easypost.requests;

import javax.ws.rs.core.Form;
import org.tiogasolutions.apis.easypost.pub.EpAddress;
import org.tiogasolutions.apis.easypost.pub.EpLabelFormat;
import org.tiogasolutions.apis.easypost.pub.EpParcel;
import org.tiogasolutions.apis.easypost.requests.EpCreateAddressRequest;
import org.tiogasolutions.apis.easypost.requests.EpCreateParcelRequest;

public class EpCreateShipmentRequest {
    private final String toAddresssId;
    private final String fromAddressId;
    private final String parcelId;
    private final EpCreateAddressRequest toAddress;
    private final EpCreateAddressRequest fromAddress;
    private final EpCreateParcelRequest parcel;
    private final EpLabelFormat labelFormat;

    public EpCreateShipmentRequest(EpParcel parcel, EpAddress fromAddress, EpAddress toAddress, EpLabelFormat labelFormat) {
        this.parcelId = parcel.getId();
        this.toAddresssId = toAddress.getId();
        this.fromAddressId = fromAddress.getId();
        this.parcel = null;
        this.fromAddress = null;
        this.toAddress = null;
        this.labelFormat = labelFormat;
    }

    public EpCreateShipmentRequest(EpCreateParcelRequest parcel, EpCreateAddressRequest fromAddress, EpCreateAddressRequest toAddresss, EpLabelFormat labelFormat) {
        this.parcel = parcel;
        this.fromAddress = fromAddress;
        this.toAddress = toAddresss;
        this.toAddresssId = null;
        this.fromAddressId = null;
        this.parcelId = null;
        this.labelFormat = labelFormat;
    }

    public EpCreateAddressRequest getToAddress() {
        return this.toAddress;
    }

    public EpCreateAddressRequest getFromAddress() {
        return this.fromAddress;
    }

    public EpCreateParcelRequest getParcel() {
        return this.parcel;
    }

    public String getToAddresssId() {
        return this.toAddresssId;
    }

    public String getFromAddressId() {
        return this.fromAddressId;
    }

    public String getParcelId() {
        return this.parcelId;
    }

    public EpLabelFormat getLabelFormat() {
        return this.labelFormat;
    }

    public Form toForm() {
        Form form = new Form();
        form.param("shipment[options][label_format]", this.labelFormat.name());
        if (this.parcelId != null) {
            form.param("shipment[to_address][id]", this.toAddresssId);
            form.param("shipment[from_address][id]", this.fromAddressId);
            form.param("shipment[parcel][id]", this.parcelId);
        } else {
            form.param("shipment[to_address][name]", this.toAddress.getName());
            form.param("shipment[to_address][company]", this.toAddress.getCompany());
            form.param("shipment[to_address][street1]", this.toAddress.getStreet1());
            form.param("shipment[to_address][street2]", this.toAddress.getStreet2());
            form.param("shipment[to_address][city]", this.toAddress.getCity());
            form.param("shipment[to_address][state]", this.toAddress.getState());
            form.param("shipment[to_address][zip]", this.toAddress.getZip());
            form.param("shipment[to_address][country]", this.toAddress.getCountry());
            form.param("shipment[to_address][phone]", this.toAddress.getPhone());
            form.param("shipment[to_address][email]", this.toAddress.getEmail());
            form.param("shipment[to_address][residential]", String.valueOf(this.toAddress.isResidential()));
            form.param("shipment[from_address][name]", this.fromAddress.getName());
            form.param("shipment[from_address][company]", this.fromAddress.getCompany());
            form.param("shipment[from_address][street1]", this.fromAddress.getStreet1());
            form.param("shipment[from_address][street2]", this.fromAddress.getStreet2());
            form.param("shipment[from_address][city]", this.fromAddress.getCity());
            form.param("shipment[from_address][state]", this.fromAddress.getState());
            form.param("shipment[from_address][zip]", this.fromAddress.getZip());
            form.param("shipment[from_address][country]", this.fromAddress.getCountry());
            form.param("shipment[from_address][phone]", this.fromAddress.getPhone());
            form.param("shipment[from_address][email]", this.fromAddress.getEmail());
            form.param("shipment[from_address][residential]", String.valueOf(this.fromAddress.isResidential()));
            if (this.parcel.getPredefinedPackage() != null) {
                form.param("shipment[parcel][weight]", String.valueOf(this.parcel.getWeight()));
                form.param("shipment[parcel][predefined_package]", this.parcel.getPredefinedPackage());
            } else {
                form.param("shipment[parcel][weight]", String.valueOf(this.parcel.getWeight()));
                form.param("shipment[parcel][length]", String.valueOf(this.parcel.getLength()));
                form.param("shipment[parcel][width]", String.valueOf(this.parcel.getWidth()));
                form.param("shipment[parcel][height]", String.valueOf(this.parcel.getHeight()));
            }
        }
        return form;
    }
}

