/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.apis.google.maps;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.net.URLConnection;
import org.tiogasolutions.apis.google.maps.DrivingDirections;
import org.tiogasolutions.apis.google.maps.Leg;
import org.tiogasolutions.dev.common.IoUtils;
import org.tiogasolutions.dev.common.StringUtils;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.dev.common.exceptions.ExceptionUtils;
import org.tiogasolutions.dev.domain.locality.LatLng;
import org.tiogasolutions.dev.domain.locality.State;
import org.tiogasolutions.dev.jackson.TiogaJacksonObjectMapper;

public class GoogleMapsUtils {
    private static final BigDecimal kmToMilesRatio = new BigDecimal("0.621371");
    private static final BigDecimal metersToMilesRatio = new BigDecimal("0.000621371");
    private static final ObjectMapper objectMapper = new TiogaJacksonObjectMapper();

    public static BigDecimal getMilesByGoogle(LatLng locationA, LatLng locationB) throws IOException {
        DrivingDirections directions = GoogleMapsUtils.getDrivingDirections(locationA, locationB);
        Leg leg = directions.getRoutes()[0].getLegs()[0];
        long meters = leg.getDistance().getMeters();
        BigDecimal miles = metersToMilesRatio.multiply(new BigDecimal(meters));
        return miles.setScale(1, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal getMilesByLatLng(LatLng locationA, LatLng locationB) {
        LatLng locationC = new LatLng(locationA.getLatitude(), locationB.getLongitude());
        BigDecimal firstLeg = GoogleMapsUtils.calculateHaversineDistance(locationA.getLatitudeDouble(), locationA.getLongitudeDouble(), locationC.getLatitudeDouble(), locationC.getLongitudeDouble());
        BigDecimal secondLeg = GoogleMapsUtils.calculateHaversineDistance(locationC.getLatitudeDouble(), locationC.getLongitudeDouble(), locationB.getLatitudeDouble(), locationB.getLongitudeDouble());
        BigDecimal miles = firstLeg.add(secondLeg);
        return miles.setScale(1, RoundingMode.HALF_EVEN);
    }

    public static DrivingDirections getDrivingDirections(LatLng locationA, LatLng locationB) throws IOException {
        ExceptionUtils.assertNotNull((Object)locationA, (String)"locationA");
        ExceptionUtils.assertNotNull((Object)locationB, (String)"locationB");
        String url = "http://maps.googleapis.com/maps/api/directions/json";
        url = url + String.format("?origin=%s,%s", locationA.getLatitude(), locationA.getLongitude());
        url = url + String.format("&destination=%s,%s", locationB.getLatitude(), locationB.getLongitude());
        url = url + "&sensor=false";
        URLConnection connection = new URL(url).openConnection();
        String json = IoUtils.toString((InputStream)connection.getInputStream());
        DrivingDirections directions = (DrivingDirections)objectMapper.readValue(json, DrivingDirections.class);
        if (directions.getStatus().isNotOK()) {
            String msg = String.format("Unable to compute driving directions: %s (%s)", new Object[]{directions.getStatus(), directions.getStatus().getDescription()});
            throw ApiException.internalServerError((String)msg, (String[])new String[0]);
        }
        return directions;
    }

    public static BigDecimal calculateHaversineDistance(double userLat, double userLng, double venueLat, double venueLng) {
        double latDistance = Math.toRadians(userLat - venueLat);
        double lngDistance = Math.toRadians(userLng - venueLng);
        double a = Math.sin(latDistance / 2.0) * Math.sin(latDistance / 2.0) + Math.cos(Math.toRadians(userLat)) * Math.cos(Math.toRadians(venueLat)) * Math.sin(lngDistance / 2.0) * Math.sin(lngDistance / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        BigDecimal kiloMeters = new BigDecimal(6372.797 * c);
        BigDecimal miles = kiloMeters.multiply(kmToMilesRatio);
        return miles.setScale(1, RoundingMode.HALF_EVEN);
    }

    public static LatLng getLatLng(String address, String city, State state, String zip) throws IOException {
        String st = state == null ? null : state.getAbbreviation();
        return GoogleMapsUtils.getLatLng(address, city, st, zip);
    }

    public static LatLng getLatLng(String address, String city, String state, String zip) throws IOException {
        String url = "https://maps.googleapis.com/maps/api/geocode/xml?sensor=false&address=";
        url = url + StringUtils.encodeUrl((Object)String.format("%s, %s, %s %s", address, city, state, zip));
        URLConnection connection = new URL(url).openConnection();
        String data = IoUtils.toString((InputStream)connection.getInputStream());
        data = StringUtils.getTagContents((Object)data, (String)"location", (int)0);
        return new LatLng(StringUtils.getTagContents((Object)data, (String)"lat", (int)0), StringUtils.getTagContents((Object)data, (String)"lng", (int)0));
    }
}

