/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.apis.google.users;

import java.io.IOException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.tiogasolutions.apis.google.users.GoogleAuthentication;
import org.tiogasolutions.apis.google.users.UserInfo;
import org.tiogasolutions.dev.common.StringUtils;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.dev.jackson.TiogaJacksonObjectMapper;

public class GoogleUsersUtils {
    private GoogleUsersUtils() {
    }

    public static GoogleAuthentication getAuthResponse(String code, String clientId, String clientSecret) throws IOException {
        Client client = ClientBuilder.newBuilder().build();
        Form form = new Form();
        form.param("code", code);
        form.param("client_id", clientId);
        form.param("client_secret", clientSecret);
        form.param("grant_type", "authorization_code");
        form.param("redirect_uri", "postmessage");
        UriBuilder uriBuilder = UriBuilder.fromUri((String)"https://accounts.google.com/o/oauth2/token");
        Response jerseyResponse = client.target(uriBuilder).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        int status = jerseyResponse.getStatus();
        String json = (String)jerseyResponse.readEntity(String.class);
        TiogaJacksonObjectMapper objectMapper = new TiogaJacksonObjectMapper();
        GoogleAuthentication googleAuth = (GoogleAuthentication)objectMapper.readValue(json, GoogleAuthentication.class);
        if (StringUtils.isNotBlank((Object)googleAuth.getError())) {
            String msg = String.format("Authentication Error: %s", googleAuth.getError());
            throw ApiException.internalServerError((String)msg, (String[])new String[0]);
        }
        return googleAuth;
    }

    public static UserInfo getUserInfo(GoogleAuthentication authentication) throws IOException {
        return GoogleUsersUtils.getUserInfo(authentication.getAccessToken());
    }

    public static UserInfo getUserInfo(String accessToken) throws IOException {
        Client client = ClientBuilder.newBuilder().build();
        UriBuilder uriBuilder = UriBuilder.fromUri((String)"https://www.googleapis.com/oauth2/v1/userinfo");
        uriBuilder.queryParam("alt", new Object[]{"json"});
        uriBuilder.queryParam("access_token", new Object[]{accessToken});
        Response response = client.target(uriBuilder).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
        String json = (String)response.readEntity(String.class);
        return (UserInfo)new TiogaJacksonObjectMapper().readValue(json, UserInfo.class);
    }
}

