/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.apis.opensrs;

import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.apis.opensrs.OpenSrsDelegate;
import org.tiogasolutions.apis.opensrs.pub.DnLookupResponse;
import org.tiogasolutions.apis.opensrs.support.MySSLSocketFactory;

public class HttpClientDelegate
extends OpenSrsDelegate {
    private static final Logger log = LoggerFactory.getLogger(HttpClientDelegate.class);
    private final HttpClient httpClient;

    public HttpClientDelegate(int maxConnections) {
        HttpClientParams params = new HttpClientParams();
        params.setConnectionManagerTimeout(180000L);
        params.setSoTimeout(120000);
        MultiThreadedHttpConnectionManager manager = new MultiThreadedHttpConnectionManager();
        manager.setMaxTotalConnections(maxConnections);
        manager.setMaxConnectionsPerHost(maxConnections);
        this.httpClient = new HttpClient(params, (HttpConnectionManager)manager);
    }

    @Override
    public DnLookupResponse lookup(String xml, String domainName, boolean noCache) throws Exception {
        String portStr = String.valueOf(55443);
        Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)new MySSLSocketFactory(), 55443));
        String uri = "https://" + this.host + ":" + portStr + "/";
        PostMethod postRequest = new PostMethod(uri);
        postRequest.addRequestHeader("Content-Length", String.valueOf(xml.length()));
        postRequest.addRequestHeader("Content-Type", "text/xml");
        postRequest.addRequestHeader("X-Username", this.username);
        String signature = this.md5Sum(this.md5Sum(xml + this.privateKey) + this.privateKey);
        postRequest.addRequestHeader("X-Signature", signature);
        postRequest.setRequestEntity((RequestEntity)new StringRequestEntity(xml, "application/xml", "utf-8"));
        try {
            this.httpClient.executeMethod((HttpMethod)postRequest);
        }
        catch (SocketTimeoutException ex) {
            log.info("Read timed out, retrying: {}", (Object)ex.getMessage());
            return this.lookup(xml, domainName, noCache);
        }
        catch (UnknownHostException ex) {
            log.info("Connection timed out, retrying: {}", (Object)ex.getMessage());
            return this.lookup(xml, domainName, noCache);
        }
        catch (Exception ex) {
            throw new Exception("Sending post got exception ", ex);
        }
        String xmlResponse = postRequest.getResponseBodyAsString();
        return DnLookupResponse.fromXmlResponse(domainName, xmlResponse);
    }
}

