/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.apis.opensrs;

import java.util.HashMap;
import javax.ws.rs.core.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.apis.opensrs.OpenSrsDelegate;
import org.tiogasolutions.apis.opensrs.pub.DnLookupResponse;
import org.tiogasolutions.dev.common.json.JsonTranslator;
import org.tiogasolutions.dev.jackson.TiogaJacksonTranslator;
import org.tiogasolutions.lib.jaxrs.client.SimpleRestClient;

public class SimpleRestClientDelegate
extends OpenSrsDelegate {
    private static final Logger log = LoggerFactory.getLogger(SimpleRestClientDelegate.class);
    private final SimpleRestClient restClient;

    public SimpleRestClientDelegate() {
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        TiogaJacksonTranslator translator = new TiogaJacksonTranslator();
        String rootUrl = String.format("https://%s:%s", this.host, 55443);
        this.restClient = new SimpleRestClient((JsonTranslator)translator, (Object)rootUrl);
    }

    @Override
    public DnLookupResponse lookup(String xml, String domainName, boolean noCache) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Length", String.valueOf(xml.length()));
        headers.put("Content-Type", "text/xml");
        headers.put("X-Username", this.username);
        String signature = this.md5Sum(this.md5Sum(xml + this.privateKey) + this.privateKey);
        headers.put("X-Signature", signature);
        String xmlResponse = (String)this.restClient.post(String.class, MediaType.TEXT_XML_TYPE, "/", (Object)xml, headers, new String[]{"application/xml"});
        return DnLookupResponse.fromXmlResponse(domainName, xmlResponse);
    }
}

