/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.apis.opensrs.pub;

import org.tiogasolutions.apis.opensrs.pub.DnStatus;

public class DnLookupResponse {
    private final String domainName;
    private final DnStatus status;
    private final int responseCode;

    public DnLookupResponse(String domainName, int responseCode, DnStatus status) {
        this.status = status;
        this.domainName = domainName;
        this.responseCode = responseCode;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public DnStatus getStatus() {
        return this.status;
    }

    public static DnLookupResponse fromXmlResponse(String domainName, String xmlResponse) {
        String status = DnLookupResponse.getTag(xmlResponse, "<item key=\"status\">", "</item>");
        DnStatus dnStatus = status == null ? null : DnStatus.valueOf(status);
        String responseCode = DnLookupResponse.getTag(xmlResponse, "<item key=\"response_code\">", "</item>");
        if (responseCode == null) {
            responseCode = "-1";
        }
        return new DnLookupResponse(domainName, Integer.valueOf(responseCode), dnStatus);
    }

    private static String getTag(String xmlResponse, String start, String end) {
        int posA = xmlResponse.indexOf(start);
        if (posA < 0) {
            return null;
        }
        int posB = xmlResponse.indexOf(end, posA += start.length());
        if (posB < 0) {
            String msg = String.format("The key %s was not found in the XML Response\n\n%s", end, xmlResponse);
            throw new RuntimeException(msg);
        }
        return xmlResponse.substring(posA, posB);
    }
}

