/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.pub;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.tiogasolutions.dev.common.net.HttpStatusCode;
import org.tiogasolutions.pub.PubLink;
import org.tiogasolutions.pub.PubLinks;
import org.tiogasolutions.pub.PubResponse;

@JsonPropertyOrder(value={"_response", "_links"})
public class PubItem {
    private final PubResponse _response;
    private final PubLinks _links;

    @JsonCreator
    protected PubItem(@JsonProperty(value="_status") PubResponse _response, @JsonProperty(value="_links") PubLinks _links) {
        this._response = _response != null ? _response : new PubResponse(HttpStatusCode.UNDEFINED);
        this._links = _links != null ? _links : PubLinks.empty();
    }

    public PubItem(PubResponse _response) {
        this(_response, null);
    }

    public PubItem(int code) {
        this(code, null);
    }

    public PubItem(int code, PubLinks _links) {
        this(PubItem.toStatus(code), _links);
    }

    public PubItem(HttpStatusCode statusCode) {
        this(statusCode, null);
    }

    public PubItem(HttpStatusCode statusCode, PubLinks _links) {
        this(PubItem.toStatus(statusCode), _links);
    }

    public PubLinks get_links() {
        return this._links;
    }

    public PubResponse get_response() {
        return this._response;
    }

    public PubLink getLink(String rel) {
        return this._links.getLink(rel);
    }

    public static PubResponse toStatus(int code) {
        HttpStatusCode statusCode = HttpStatusCode.findByCode((int)code);
        return new PubResponse(statusCode);
    }

    public static PubResponse toStatus(HttpStatusCode statusCode) {
        return new PubResponse(statusCode);
    }
}

