/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.lib.selenium;

import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.Select;
import org.tiogasolutions.lib.selenium.SeleniumBrowserException;

public class WebElementReference {
    private final By by;
    private final long defaultTimeout;
    private final WebDriver webDriver;
    private final SearchContext searchContext;

    public WebElementReference(WebDriver webDriver, By by, long defaultTimeout) {
        this(webDriver, (SearchContext)webDriver, by, defaultTimeout);
    }

    public WebElementReference(WebDriver webDriver, String key, long defaultTimeout) {
        this(webDriver, (SearchContext)webDriver, key, defaultTimeout);
    }

    public WebElementReference(WebDriver webDriver, SearchContext searchContext, By by, long defaultTimeout) {
        this.by = by;
        this.webDriver = webDriver;
        this.searchContext = searchContext;
        this.defaultTimeout = defaultTimeout;
    }

    public WebElementReference(WebDriver webDriver, SearchContext searchContext, String key, long defaultTimeout) {
        this.webDriver = webDriver;
        this.searchContext = searchContext;
        this.defaultTimeout = defaultTimeout;
        if (key.startsWith("#")) {
            key = key.substring(1);
            this.by = By.id((String)key);
        } else if (key.startsWith(".")) {
            key = key.substring(1);
            this.by = By.className((String)key);
        } else {
            String msg = String.format("Cannot get element for key \"%s\".", key);
            throw new SeleniumBrowserException(msg);
        }
    }

    private void sleep(int duration) {
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException e) {
            throw new SeleniumBrowserException(e);
        }
    }

    public boolean isPresent() {
        return !this.searchContext.findElements(this.by).isEmpty();
    }

    public boolean isNotPresent() {
        return this.searchContext.findElements(this.by).isEmpty();
    }

    public Point getCenter() throws SeleniumBrowserException {
        return this.getCenter(this.defaultTimeout);
    }

    public Point getCenter(long timeout) throws SeleniumBrowserException {
        WebElement element = this.waitFor(timeout);
        Point location = element.getLocation();
        Dimension dimension = element.getSize();
        location.x += (int)((double)dimension.width / 2.0);
        location.y += (int)((double)dimension.height / 2.0);
        return location;
    }

    public WebElementReference click() throws SeleniumBrowserException {
        return this.click(this.defaultTimeout);
    }

    public WebElementReference click(long timeout) throws SeleniumBrowserException {
        try {
            this.waitFor(timeout).click();
            return this;
        }
        catch (WebDriverException e) {
            String msg = String.format("Unexpected exception clicking %s with %s ms timeout.", this.by, this.defaultTimeout);
            throw new SeleniumBrowserException(msg, e);
        }
    }

    public WebElementReference submit() {
        return this.submit(this.defaultTimeout);
    }

    public WebElementReference submit(long timeout) {
        this.waitFor(timeout).submit();
        return this;
    }

    public WebElementReference sendKeys(CharSequence text) throws SeleniumBrowserException {
        return this.sendKeys(text, this.defaultTimeout);
    }

    public WebElementReference sendKeys(CharSequence text, long timeout) throws SeleniumBrowserException {
        try {
            this.waitFor(timeout).sendKeys(new CharSequence[]{text});
            return this;
        }
        catch (WebDriverException e) {
            String msg = String.format("Unexpected exception sending keys to \"%s\" with %s ms timeout.", this.by, this.defaultTimeout);
            throw new SeleniumBrowserException(msg, e);
        }
    }

    public WebElementReference clear() throws SeleniumBrowserException {
        return this.clear(this.defaultTimeout);
    }

    public WebElementReference clear(long timeout) throws SeleniumBrowserException {
        try {
            this.waitFor(timeout).clear();
            return this;
        }
        catch (WebDriverException e) {
            String msg = String.format("Unexpected exception clearing \"%s\" with %s ms timeout.", this.by, this.defaultTimeout);
            throw new SeleniumBrowserException(msg, e);
        }
    }

    public String getTagName() {
        return this.getTagName(this.defaultTimeout);
    }

    public String getTagName(long timeout) {
        return this.waitFor(timeout).getTagName();
    }

    public String getAttribute(String name) {
        return this.getAttribute(name, this.defaultTimeout);
    }

    public String getAttribute(String name, long timeout) {
        return this.waitFor(timeout).getAttribute(name);
    }

    public boolean isSelected() {
        return this.isSelected(this.defaultTimeout);
    }

    public boolean isSelected(long timeout) {
        return this.waitFor(timeout).isSelected();
    }

    public boolean isEnabled() {
        return this.isEnabled(this.defaultTimeout);
    }

    public boolean isEnabled(long timeout) {
        return this.waitFor(timeout).isEnabled();
    }

    public boolean isDisplayed() {
        return this.isDisplayed(this.defaultTimeout);
    }

    public boolean isDisplayed(long timeout) {
        return this.waitFor(timeout).isDisplayed();
    }

    public Point getLocation() {
        return this.getLocation(this.defaultTimeout);
    }

    public Point getLocation(long timeout) {
        return this.waitFor(timeout).getLocation();
    }

    public Dimension getSize() {
        return this.getSize(this.defaultTimeout);
    }

    public Dimension getSize(long timeout) {
        return this.waitFor(timeout).getSize();
    }

    public String getCssValue(String propertyName) {
        return this.getCssValue(propertyName, this.defaultTimeout);
    }

    public String getCssValue(String propertyName, long timeout) throws SeleniumBrowserException {
        return this.waitFor(timeout).getCssValue(propertyName);
    }

    public WebElementReference moveTo() throws SeleniumBrowserException {
        return this.moveTo(this.defaultTimeout);
    }

    public WebElementReference moveTo(long timeout) throws SeleniumBrowserException {
        try {
            new Actions(this.webDriver).moveToElement(this.waitFor(timeout));
            return this;
        }
        catch (WebDriverException e) {
            String msg = String.format("Unexpected exception moving to \"%s\" with %s ms timeout.", this.by, this.defaultTimeout);
            throw new SeleniumBrowserException(msg, e);
        }
    }

    public String getText() throws SeleniumBrowserException {
        return this.getText(this.defaultTimeout);
    }

    public String getText(long timeout) throws SeleniumBrowserException {
        try {
            return this.waitFor(timeout).getText();
        }
        catch (WebDriverException e) {
            String msg = String.format("Unexpected exception getting text for %s with %s ms timeout.", this.by, this.defaultTimeout);
            throw new SeleniumBrowserException(msg, e);
        }
    }

    public WebElementReference waitForText(String message) throws SeleniumBrowserException {
        return this.waitForText(message, this.defaultTimeout);
    }

    public WebElementReference waitForText(String message, long timeout) throws SeleniumBrowserException {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < timeout) {
            long elapsed = System.currentTimeMillis() - start;
            long remaining = timeout - elapsed;
            String text = this.waitFor(remaining).getText();
            if (text.equals(message)) {
                return this;
            }
            this.sleep(250);
        }
        String msg = String.format("The element \"%s\" did not have a value of \"%s\" after %s milliseconds.", this.by, message, timeout);
        throw new SeleniumBrowserException(msg);
    }

    public WebElement getWebElement() {
        return this.searchContext.findElement(this.by);
    }

    public List<WebElement> getWebElements() {
        return this.searchContext.findElements(this.by);
    }

    public WebElementReference waitToAppear() throws SeleniumBrowserException {
        return this.waitToAppear(this.defaultTimeout);
    }

    public WebElementReference waitToAppear(long timeout) throws SeleniumBrowserException {
        this.waitFor(timeout);
        return this;
    }

    private WebElement waitFor(long timeout) {
        long start = System.currentTimeMillis();
        List elements = new ArrayList();
        while (System.currentTimeMillis() - start < timeout) {
            elements = this.searchContext.findElements(this.by);
            if (elements.isEmpty()) {
                this.sleep(250);
                continue;
            }
            if (!((WebElement)elements.get(0)).isDisplayed()) {
                this.sleep(250);
                continue;
            }
            return (WebElement)elements.get(0);
        }
        if (elements.isEmpty()) {
            String msg = String.format("The element \"%s\" was not found after %s milliseconds.", this.by, timeout);
            throw new SeleniumBrowserException(msg);
        }
        String msg = String.format("The element \"%s\" was found but is not displayed after %s milliseconds.", this.by, timeout);
        throw new SeleniumBrowserException(msg);
    }

    public void waitToDisappear() throws SeleniumBrowserException {
        this.waitToDisappear(this.defaultTimeout);
    }

    public void waitToDisappear(long timeout) throws SeleniumBrowserException {
        long start = System.currentTimeMillis();
        List elements = new ArrayList();
        while (System.currentTimeMillis() - start < timeout) {
            elements = this.searchContext.findElements(this.by);
            if (elements.isEmpty()) {
                return;
            }
            int visible = 0;
            for (WebElement element : elements) {
                try {
                    if (!element.isDisplayed()) continue;
                    ++visible;
                }
                catch (StaleElementReferenceException staleElementReferenceException) {}
            }
            if (visible == 0) {
                return;
            }
            this.sleep(250);
        }
        if (!elements.isEmpty()) {
            String msg = String.format("The element \"%s\" was found after %s milliseconds.", this.by, timeout);
            throw new SeleniumBrowserException(msg);
        }
    }

    public WebElementReference isMultiSelect() {
        return this.isMultiSelect(this.defaultTimeout);
    }

    public WebElementReference isMultiSelect(long timeout) {
        new Select(this.waitFor(timeout)).isMultiple();
        return this;
    }

    public List<WebElement> getSelectOptions() {
        return this.getSelectOptions(this.defaultTimeout);
    }

    public List<WebElement> getSelectOptions(long timeout) {
        return new Select(this.waitFor(timeout)).getOptions();
    }

    public List<WebElement> getAllSelectedOptions() {
        return this.getAllSelectedOptions(this.defaultTimeout);
    }

    public List<WebElement> getAllSelectedOptions(long timeout) {
        return new Select(this.waitFor(timeout)).getAllSelectedOptions();
    }

    public WebElement getFirstSelectedOption() {
        return this.getFirstSelectedOption(this.defaultTimeout);
    }

    public WebElement getFirstSelectedOption(long timeout) {
        return new Select(this.waitFor(timeout)).getFirstSelectedOption();
    }

    public WebElementReference selectByVisibleText(String text) {
        return this.selectByVisibleText(text, this.defaultTimeout);
    }

    public WebElementReference selectByVisibleText(String text, long timeout) {
        new Select(this.waitFor(timeout)).selectByVisibleText(text);
        return this;
    }

    public WebElementReference selectByIndex(int index) {
        return this.selectByIndex(index, this.defaultTimeout);
    }

    public WebElementReference selectByIndex(int index, long timeout) {
        new Select(this.waitFor(timeout)).selectByIndex(index);
        return this;
    }

    public WebElementReference selectByValue(String value) {
        return this.selectByValue(value, this.defaultTimeout);
    }

    public WebElementReference selectByValue(String value, long timeout) {
        new Select(this.waitFor(timeout)).selectByValue(value);
        return this;
    }

    public WebElementReference deselectAll() {
        return this.deselectAll(this.defaultTimeout);
    }

    public WebElementReference deselectAll(long timeout) {
        new Select(this.waitFor(timeout)).deselectAll();
        return this;
    }

    public WebElementReference deselectByValue(String value) {
        return this.deselectByValue(value, this.defaultTimeout);
    }

    public WebElementReference deselectByValue(String value, long timeout) {
        new Select(this.waitFor(timeout)).deselectByValue(value);
        return this;
    }

    public WebElementReference deselectByIndex(int index) {
        return this.deselectByIndex(index, this.defaultTimeout);
    }

    public WebElementReference deselectByIndex(int index, long timeout) {
        new Select(this.waitFor(timeout)).deselectByIndex(index);
        return this;
    }

    public WebElementReference deselectByVisibleText(String text) {
        return this.deselectByVisibleText(text, this.defaultTimeout);
    }

    public WebElementReference deselectByVisibleText(String text, long timeout) {
        new Select(this.waitFor(timeout)).deselectByVisibleText(text);
        return this;
    }
}

