/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.lib.servlet.template.decorators;

public class Anchor {
    public String name;
    public String title;

    public Anchor(String tagText) {
        this.name = this.findName(tagText);
        this.title = this.findTitle(tagText);
    }

    private String findName(String tagText) {
        int pos = tagText.indexOf("name");
        if (pos != -1) {
            return this.findValue(tagText, pos);
        }
        return null;
    }

    private String findTitle(String tagText) {
        int pos = tagText.indexOf("title");
        if (pos != -1) {
            return this.findValue(tagText, pos);
        }
        return null;
    }

    private String findValue(String tagText, int pos) {
        int index;
        int start = 0;
        int end = 0;
        char[] chrs = tagText.toCharArray();
        for (index = pos; index < chrs.length; ++index) {
            if (chrs[index] != '=') continue;
            start = index + 1;
            break;
        }
        for (index = start; index < chrs.length; ++index) {
            if (chrs[index] != '\'' && chrs[index] != '\"') continue;
            start = index + 1;
            break;
        }
        for (index = start; index < chrs.length; ++index) {
            if (chrs[index] != '\'' && chrs[index] != '\"') continue;
            end = index;
            break;
        }
        if (end > start) {
            return tagText.substring(start, end);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": title=\"" + this.title + "\" name=\"" + this.name + "\"";
    }
}

